/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.lib.bytebuddy.dynamic.scaffold.inline;

import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.method.MethodDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.utility.RandomString;

public interface MethodNameTransformer {
    public String transform(MethodDescription var1);

    public static class Prefixing
    implements MethodNameTransformer {
        private static final String DEFAULT_PREFIX = "original";
        private final String prefix;

        public Prefixing() {
            this(DEFAULT_PREFIX);
        }

        public Prefixing(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public String transform(MethodDescription methodDescription) {
            return String.format("%s%s", this.prefix, methodDescription.getInternalName());
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Prefixing)) {
                return false;
            }
            Prefixing other = (Prefixing)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$prefix = this.prefix;
            String other$prefix = other.prefix;
            return !(this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Prefixing;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $prefix = this.prefix;
            result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
            return result;
        }
    }

    public static class Suffixing
    implements MethodNameTransformer {
        private static final String DEFAULT_SUFFIX = "original$";
        private final String suffix;

        public static MethodNameTransformer withRandomSuffix() {
            return new Suffixing(DEFAULT_SUFFIX + RandomString.make());
        }

        public Suffixing(String suffix) {
            this.suffix = suffix;
        }

        @Override
        public String transform(MethodDescription methodDescription) {
            return String.format("%s$%s", methodDescription.getInternalName(), this.suffix);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Suffixing)) {
                return false;
            }
            Suffixing other = (Suffixing)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$suffix = this.suffix;
            String other$suffix = other.suffix;
            return !(this$suffix == null ? other$suffix != null : !this$suffix.equals(other$suffix));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Suffixing;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $suffix = this.suffix;
            result = result * 59 + ($suffix == null ? 43 : $suffix.hashCode());
            return result;
        }
    }
}

