/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.DirectUpload;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.io.GpxWriter;
import org.openstreetmap.josm.tools.I18n;

public class UploadDataGui
extends JFrame {
    String tagging;
    String Descriptionfield;
    String urlDescription;
    String urlTags;
    String UserName;
    String PassWord;
    public static final String API_VERSION = "0.5";
    private static final String BASE64_ENC = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    private static final String BOUNDARY = "----------------------------d10f7aa230e8";
    private static final String LINE_END = "\r\n";
    boolean dfield;
    boolean taggy;
    boolean choosy;
    boolean user;
    boolean pass;
    boolean publicheck;
    DateFormat dateFormat = new SimpleDateFormat("yyMMddHHmmss");
    Date date = new Date();
    String datename = this.dateFormat.format(this.date);
    private JButton CancelButton;
    private JButton OkButton;
    private JTextArea OutputDisplay;
    private JCheckBox PublicTrace;
    private JTextField descriptionfield;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JScrollPane jScrollPane1;
    private JTextField tagfield;

    public UploadDataGui() {
        this.initComponents();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.OutputDisplay = new JTextArea();
        this.OkButton = new JButton();
        this.CancelButton = new JButton();
        this.jLabel2 = new JLabel();
        this.PublicTrace = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.descriptionfield = new JTextField();
        this.jLabel3 = new JLabel();
        this.tagfield = new JTextField();
        this.setDefaultCloseOperation(2);
        this.setAlwaysOnTop(true);
        this.OutputDisplay.setColumns(20);
        this.OutputDisplay.setRows(5);
        this.jScrollPane1.setViewportView(this.OutputDisplay);
        this.OkButton.setText("Ok");
        this.OkButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UploadDataGui.this.OkButtonActionPerformed(evt);
            }
        });
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UploadDataGui.this.CancelButtonActionPerformed(evt);
            }
        });
        this.jLabel2.setFont(new Font("DejaVu Sans", 1, 14));
        this.jLabel2.setText("Direct Upload to OpenStreetMap");
        this.PublicTrace.setText("Public");
        this.PublicTrace.setToolTipText("Selected makes your trace public in openstreetmap.org");
        this.PublicTrace.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                UploadDataGui.this.PublicTraceItemStateChanged(evt);
            }
        });
        this.jLabel1.setText("Description");
        this.descriptionfield.setToolTipText("Please enter Description about your trace.");
        this.descriptionfield.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                UploadDataGui.this.descriptionfieldFocusLost(evt);
            }
        });
        this.jLabel3.setText("Tags");
        this.tagfield.setToolTipText("Please enter tags about your trace.");
        this.tagfield.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                UploadDataGui.this.tagfieldFocusLost(evt);
            }
        });
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.fill = 1;
        contentPane.add((Component)this.OutputDisplay, c);
        c.gridwidth = 1;
        c.gridy = 1;
        contentPane.add((Component)this.jLabel3, c);
        c.gridx = 1;
        contentPane.add((Component)this.tagfield, c);
        c.gridy = 2;
        c.gridx = 0;
        contentPane.add((Component)this.jLabel1, c);
        c.gridx = 1;
        contentPane.add((Component)this.descriptionfield, c);
        c.gridy = 3;
        c.gridx = 0;
        contentPane.add((Component)this.jLabel2, c);
        c.gridx = 1;
        contentPane.add((Component)this.PublicTrace, c);
        c.gridy = 4;
        c.gridx = 0;
        contentPane.add((Component)this.CancelButton, c);
        c.gridx = 1;
        contentPane.add((Component)this.OkButton, c);
        this.pack();
    }

    public void upload(String username, String password, String Descriptionfield, String tagging, GpxData gpxData) throws IOException {
        this.OutputDisplay.setText("Starting to upload selected file to openstreetmap.org");
        try {
            this.urlDescription = Descriptionfield.replaceAll("\\.;&?,/", "_");
            if (this.urlDescription == null || this.urlDescription.length() == 0) {
                this.OutputDisplay.setText("No description provided .Please provide some description . For the time being ignore the exception error ");
            }
            this.urlTags = tagging.replaceAll("\\\\.;&?,/", "_");
            URL url = new URL("http://www.openstreetmap.org/api/0.5/gpx/create");
            System.err.println("url: " + url);
            this.OutputDisplay.setText("Uploading in Progress");
            HttpURLConnection connect = (HttpURLConnection)url.openConnection();
            connect.setConnectTimeout(15000);
            connect.setRequestMethod("POST");
            connect.setDoOutput(true);
            connect.addRequestProperty("Authorization", "Basic " + this.encodeBase64(username + ":" + password));
            connect.addRequestProperty("Content-Type", "multipart/form-data; boundary=----------------------------d10f7aa230e8");
            connect.addRequestProperty("Connection", "close");
            connect.addRequestProperty("Expect", "");
            connect.connect();
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(connect.getOutputStream()));
            this.writeContentDispositionGpxData(out, "file", gpxData);
            this.writeContentDisposition(out, "description", this.urlDescription);
            this.writeContentDisposition(out, "tags", this.urlTags);
            if (this.publicheck) {
                System.out.println(this.publicheck);
                this.writeContentDisposition(out, "public", "1");
            } else {
                this.writeContentDisposition(out, "public", "0");
            }
            out.writeBytes("------------------------------d10f7aa230e8--\r\n");
            out.flush();
            int returnCode = connect.getResponseCode();
            String returnMsg = connect.getResponseMessage();
            System.err.println(returnCode);
            this.OutputDisplay.setText(returnMsg);
            if (returnCode != 200) {
                if (connect.getHeaderField("Error") != null) {
                    returnMsg = returnMsg + "\n" + connect.getHeaderField("Error");
                }
                connect.disconnect();
            }
            out.close();
            connect.disconnect();
        }
        catch (UnsupportedEncodingException ignore) {
        }
        catch (MalformedURLException e) {
            this.OutputDisplay.setText("Cant Upload .");
            e.printStackTrace();
        }
    }

    public static String getPreferencesDir() {
        if (System.getenv("APPDATA") != null) {
            return System.getenv("APPDATA") + "/JOSM/";
        }
        return System.getProperty("user.home") + "/.josm/";
    }

    private void OkButtonActionPerformed(ActionEvent evt) {
        this.UserName = Main.pref.get("osm-server.username");
        this.PassWord = Main.pref.get("osm-server.password");
        if (Main.map == null || Main.map.mapView == null || Main.map.mapView.getActiveLayer() == null || !(Main.map.mapView.getActiveLayer() instanceof GpxLayer)) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"No GpxLayer selected. Cannot upload a trace."));
            return;
        }
        GpxData gpxData = ((GpxLayer)Main.map.mapView.getActiveLayer()).data;
        System.out.println(this.Descriptionfield);
        try {
            this.upload(this.UserName, this.PassWord, this.Descriptionfield, this.tagging, gpxData);
        }
        catch (IOException ex) {
            Logger.getLogger(UploadDataGui.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void PublicTraceItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.publicheck = true;
        }
    }

    private void descriptionfieldFocusLost(FocusEvent evt) {
        JTextField Descsel = (JTextField)evt.getSource();
        this.Descriptionfield = Descsel.getText();
    }

    private void tagfieldFocusLost(FocusEvent evt) {
        JTextField Tagsel = (JTextField)evt.getSource();
        this.tagging = Tagsel.getText();
    }

    private void writeContentDisposition(DataOutputStream out, String name, String value) throws IOException {
        out.writeBytes("------------------------------d10f7aa230e8\r\n");
        out.writeBytes("Content-Disposition: form-data; name=\"" + name + "\"" + LINE_END);
        out.writeBytes(LINE_END);
        out.writeBytes(value + LINE_END);
    }

    private void writeContentDispositionGpxData(DataOutputStream out, String name, GpxData gpxData) throws IOException {
        out.writeBytes("------------------------------d10f7aa230e8\r\n");
        out.writeBytes("Content-Disposition: form-data; name=\"" + name + "\"; filename=\"" + this.datename + ".gpx" + "\"" + LINE_END);
        out.writeBytes("Content-Type: application/octet-stream\r\n");
        out.writeBytes(LINE_END);
        this.OutputDisplay.setText("Transferring data to server");
        new GpxWriter((OutputStream)out).write(gpxData);
        out.flush();
        out.writeBytes(LINE_END);
    }

    public String encodeBase64(String s) {
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < (s.length() + 2) / 3; ++i) {
            int l = Math.min(3, s.length() - i * 3);
            String buf = s.substring(i * 3, i * 3 + l);
            out.append(BASE64_ENC.charAt(buf.charAt(0) >> 2));
            out.append(BASE64_ENC.charAt((buf.charAt(0) & 3) << 4 | (l == 1 ? 0 : (buf.charAt(1) & 0xF0) >> 4)));
            out.append(l > 1 ? BASE64_ENC.charAt((buf.charAt(1) & 0xF) << 2 | (l == 2 ? 0 : (buf.charAt(2) & 0xC0) >> 6)) : (char)'=');
            out.append(l > 2 ? BASE64_ENC.charAt(buf.charAt(2) & 0x3F) : (char)'=');
        }
        return out.toString();
    }
}

