/*
 * Decompiled with CFR 0.152.
 */
package at.dallermassl.josm.plugin.surveyor.action;

import at.dallermassl.josm.plugin.surveyor.GpsActionEvent;
import at.dallermassl.josm.plugin.surveyor.SurveyorAction;
import java.util.List;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.preferences.TaggingPresetPreference;
import org.openstreetmap.josm.gui.tagging.TaggingPreset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaggingPresetAction
implements SurveyorAction {
    private String presetName;
    private TaggingPreset preset;

    @Override
    public void actionPerformed(GpsActionEvent event) {
        if (this.preset == null) {
            return;
        }
        LatLon coordinates = event.getCoordinates();
        System.out.println(this.getClass().getSimpleName() + " KOORD: " + coordinates.lat() + ", " + coordinates.lon() + ", preset=" + this.presetName);
        this.preset.actionPerformed(null);
    }

    @Override
    public void setParameters(List<String> parameters) {
        if (parameters.size() == 0) {
            throw new IllegalArgumentException("No annotation preset name given!");
        }
        this.presetName = parameters.get(0);
        this.preset = this.getAnnotationPreset(this.presetName);
        if (this.preset == null) {
            System.err.println("No valid preset '" + parameters.get(0) + "' found - disable action!");
            return;
        }
    }

    protected TaggingPreset getAnnotationPreset(String name) {
        for (TaggingPreset preset : TaggingPresetPreference.taggingPresets) {
            if (!name.equals(preset.getValue("Name"))) continue;
            return preset;
        }
        return null;
    }
}

