/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.interfaces.TileCache;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoaderListener;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;

public class OsmTileLoader
implements TileLoader {
    protected TileLoaderListener listener;

    public OsmTileLoader(TileLoaderListener listener) {
        this.listener = listener;
    }

    public Runnable createTileLoaderJob(final TileSource source, final int tilex, final int tiley, final int zoom) {
        return new Runnable(){
            InputStream input = null;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Tile tile;
                TileCache cache;
                TileCache tileCache = cache = OsmTileLoader.this.listener.getTileCache();
                synchronized (tileCache) {
                    tile = cache.getTile(source, tilex, tiley, zoom);
                    if (tile == null || tile.isLoaded() || tile.loading) {
                        return;
                    }
                    tile.loading = true;
                }
                try {
                    this.input = OsmTileLoader.this.loadTileFromOsm(tile).getInputStream();
                    tile.loadImage(this.input);
                    tile.setLoaded(true);
                    OsmTileLoader.this.listener.tileLoadingFinished(tile, true);
                    this.input.close();
                    this.input = null;
                }
                catch (Exception e) {
                    tile.setImage(Tile.ERROR_IMAGE);
                    OsmTileLoader.this.listener.tileLoadingFinished(tile, false);
                    if (this.input == null) {
                        System.err.println("failed loading " + zoom + "/" + tilex + "/" + tiley + " " + e.getMessage());
                    }
                }
                finally {
                    tile.loading = false;
                    tile.setLoaded(true);
                }
            }
        };
    }

    protected HttpURLConnection loadTileFromOsm(Tile tile) throws IOException {
        URL url = new URL(tile.getUrl());
        HttpURLConnection urlConn = (HttpURLConnection)url.openConnection();
        urlConn.setReadTimeout(30000);
        return urlConn;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

