/*
 * Decompiled with CFR 0.152.
 */
package waypoints;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.xml.parsers.ParserConfigurationException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.DiskAccessAction;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import org.xml.sax.SAXException;
import waypoints.WaypointReader;

public class WaypointOpenAction
extends DiskAccessAction {
    public WaypointOpenAction() {
        super(I18n.tr((String)"Open waypoints file"), "open", I18n.tr((String)"Open a waypoints file."), Shortcut.registerShortcut((String)"tools:waypoints", (String)I18n.tr((String)"Menu: {0}", (Object[])new Object[]{I18n.tr((String)"Open waypoints file")}), (int)87, (int)2, (int)1));
    }

    public void actionPerformed(ActionEvent e) {
        JFileChooser fc = WaypointOpenAction.createAndOpenFileChooser((boolean)true, (boolean)true, null);
        if (fc == null) {
            return;
        }
        File[] files = fc.getSelectedFiles();
        for (int i = files.length; i > 0; --i) {
            this.openFile(files[i - 1]);
        }
    }

    public void openFile(File file) {
        String fn = file.getName();
        try {
            DataSet dataSet = WaypointReader.parse(new FileInputStream(file));
            Main.main.addLayer((Layer)new OsmDataLayer(dataSet, file.getName(), file));
        }
        catch (SAXException x) {
            x.printStackTrace();
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Error while parsing {0}", (Object[])new Object[]{fn}) + ": " + x.getMessage());
        }
        catch (ParserConfigurationException x) {
            x.printStackTrace();
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Error while parsing {0}", (Object[])new Object[]{fn}) + ": " + x.getMessage());
        }
        catch (IOException x) {
            x.printStackTrace();
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Could not read \"{0}\"", (Object[])new Object[]{fn}) + "\n" + x.getMessage());
        }
    }
}

