/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.measurement;

import javax.swing.Action;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.IconToggleButton;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.measurement.MeasurementDialog;
import org.openstreetmap.josm.plugins.measurement.MeasurementLayer;
import org.openstreetmap.josm.plugins.measurement.MeasurementMode;
import org.openstreetmap.josm.tools.I18n;

public class MeasurementPlugin
extends Plugin {
    private IconToggleButton btn;
    private MeasurementMode mode = new MeasurementMode(Main.map, "measurement", I18n.tr((String)"measurement mode"));
    protected static MeasurementDialog measurementDialog;
    protected static MeasurementLayer currentLayer;

    public MeasurementPlugin() {
        this.btn = new IconToggleButton((Action)((Object)this.mode));
        this.btn.setVisible(true);
        measurementDialog = new MeasurementDialog();
    }

    public void mapFrameInitialized(MapFrame mapFrame, MapFrame mapFrame2) {
        if (mapFrame2 != null) {
            mapFrame2.addToggleDialog((ToggleDialog)measurementDialog);
        }
        if (Main.map != null) {
            Main.map.addMapMode(this.btn);
        }
    }

    public static MeasurementLayer getCurrentLayer() {
        if (currentLayer == null) {
            currentLayer = new MeasurementLayer(I18n.tr((String)"Measurements"));
            Main.main.addLayer((Layer)currentLayer);
            MeasurementLayer.listeners.add(new Layer.LayerChangeListener(){

                public void activeLayerChange(Layer layer, Layer layer2) {
                    if (layer2 instanceof MeasurementLayer) {
                        currentLayer = (MeasurementLayer)layer2;
                    }
                }

                public void layerAdded(Layer layer) {
                }

                public void layerRemoved(Layer layer) {
                }
            });
        }
        return currentLayer;
    }
}

