/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.measurement;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.Collection;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.plugins.measurement.MeasurementLayer;
import org.openstreetmap.josm.plugins.measurement.MeasurementPlugin;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class MeasurementDialog
extends ToggleDialog
implements ActionListener {
    private static final long serialVersionUID = 4708541586297950021L;
    private SideButton resetButton;
    protected JLabel pathLengthLabel;
    protected JLabel selectLengthLabel;
    protected JLabel selectAreaLabel;
    protected JLabel segAngleLabel;

    public MeasurementDialog() {
        super(I18n.tr((String)"Measured values"), "measure", I18n.tr((String)"Open the measurement window."), Shortcut.registerShortcut((String)"subwindow:measurement", (String)I18n.tr((String)"Toggle: {0}", (Object[])new Object[]{I18n.tr((String)"Measured values")}), (int)77, (int)4), 150);
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        this.resetButton = new SideButton(I18n.marktr((String)"Reset"), "select", "Measurement", I18n.tr((String)"Reset current measurement results and delete measurement path."), (ActionListener)this);
        jPanel.add((Component)this.resetButton);
        this.add(jPanel, "South");
        JPanel jPanel2 = new JPanel(new GridLayout(0, 2));
        jPanel2.add(new JLabel(I18n.tr((String)"Path Length")));
        this.pathLengthLabel = new JLabel("0 m");
        jPanel2.add(this.pathLengthLabel);
        jPanel2.add(new JLabel(I18n.tr((String)"Selection Length")));
        this.selectLengthLabel = new JLabel("0 m");
        jPanel2.add(this.selectLengthLabel);
        jPanel2.add(new JLabel(I18n.tr((String)"Selection Area")));
        this.selectAreaLabel = new JLabel("0 m\u00b2");
        jPanel2.add(this.selectAreaLabel);
        JLabel jLabel = new JLabel(I18n.tr((String)"Angle"));
        jLabel.setToolTipText(I18n.tr((String)"Angle between two selected Nodes"));
        jPanel2.add(jLabel);
        this.segAngleLabel = new JLabel("- \u00b0");
        jPanel2.add(this.segAngleLabel);
        this.add(jPanel2, "Center");
        this.setPreferredSize(new Dimension(0, 92));
        final MeasurementDialog measurementDialog = this;
        DataSet.selListeners.add(new SelectionChangedListener(){

            public void selectionChanged(Collection<? extends OsmPrimitive> collection) {
                double d = 0.0;
                double d2 = 0.0;
                double d3 = 0.0;
                Node node = null;
                for (OsmPrimitive osmPrimitive : collection) {
                    Node node2;
                    if (osmPrimitive instanceof Node) {
                        node2 = (Node)osmPrimitive;
                        if (node == null) {
                            node = node2;
                            continue;
                        }
                        d += MeasurementLayer.calcDistance(node.coor, node2.coor);
                        d2 = MeasurementLayer.angleBetween(node.coor, node2.coor);
                        node = node2;
                        continue;
                    }
                    if (!(osmPrimitive instanceof Way)) continue;
                    node2 = (Way)osmPrimitive;
                    Node node3 = null;
                    for (Node node4 : node2.nodes) {
                        if (node3 != null) {
                            d += MeasurementLayer.calcDistance(node3.coor, node4.coor);
                            d3 += MeasurementLayer.calcX(node4.coor) * MeasurementLayer.calcY(node3.coor) - MeasurementLayer.calcY(node4.coor) * MeasurementLayer.calcX(node3.coor);
                        }
                        node3 = node4;
                    }
                    if (node3 != null && node3 == node2.nodes.iterator().next()) {
                        d3 = Math.abs(d3 / 2.0);
                        continue;
                    }
                    d3 = 0.0;
                }
                measurementDialog.selectLengthLabel.setText(new DecimalFormat("#0.00").format(d) + " m");
                measurementDialog.segAngleLabel.setText(new DecimalFormat("#0.0").format(d2) + " \u00b0");
                measurementDialog.selectAreaLabel.setText(new DecimalFormat("#0.00").format(d3) + " m\u00b2");
            }
        });
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Reset")) {
            this.resetValues();
        }
    }

    public void resetValues() {
        MeasurementPlugin.getCurrentLayer().reset();
    }
}

