/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.globalsat;

import gnu.io.CommPortIdentifier;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.kaintoch.gps.globalsat.dg100.ByteHelper;
import org.kaintoch.gps.globalsat.dg100.Dg100Config;
import org.kaintoch.gps.globalsat.dg100.FileInfoRec;
import org.kaintoch.gps.globalsat.dg100.GpsRec;
import org.kaintoch.gps.globalsat.dg100.Response;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.WayPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalsatDg100 {
    public static final int TIMEOUT = 2000;
    public static final int TRACK_TYPE = 1;
    private static byte[] dg100CmdSwitch2Nmea = new byte[]{-96, -94, 0, 24, -127, 2, 1, 1, 0, 1, 1, 1, 5, 1, 1, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 37, -128, 0, 0, -80, -77};
    private static byte[] dg100CmdEnterGMouse = new byte[]{-96, -94, 0, 2, -68, 1, 0, -67, -80, -77};
    private static byte[] dg100CmdDelFile = new byte[]{-96, -94, 0, 3, -70, -1, -1, 2, -72, -80, -77};
    private static byte[] dg100CmdGetFileInfo = new byte[]{-96, -94, 0, 3, -69, 0, 0, 0, -69, -80, -77};
    private static byte[] dg100CmdGetGpsRecs = new byte[]{-96, -94, 0, 3, -75, 0, 2, 0, -73, -80, -77};
    private static byte[] dg100CmdGetConfig = new byte[]{-96, -94, 0, 1, -73, 0, -73, -80, -77};
    private static byte[] dg100CmdSetConfig = new byte[]{-96, -94, 0, 42, -72, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, -24, 0, 0, 3, -24, 0, 0, 3, -24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, -80, -77};
    private static byte[] dg100CmdGetId = new byte[]{-96, -94, 0, 1, -65, 0, -65, -80, -77};
    private static byte[] dg100CmdSetId = new byte[]{-96, -94, 0, 9, -64, 0, 0, 0, 0, 0, 0, 0, 0, 0, -64, -80, -77};
    private byte[] response = new byte[65536];
    private CommPortIdentifier portIdentifier;
    private SerialPort port = null;
    private boolean cancelled = false;

    public GlobalsatDg100(CommPortIdentifier commPortIdentifier) {
        this.portIdentifier = commPortIdentifier;
    }

    public void cancel() {
        this.cancelled = true;
        this.disconnect();
    }

    public GpxData readData() throws ConnectionException {
        GpxData gpxData = null;
        int n = 0;
        this.cancelled = false;
        if (this.port == null) {
            this.connect();
        }
        Main.pleaseWaitDlg.progress.setValue(0);
        List<FileInfoRec> list = this.readFileInfoList();
        List<GpsRec> list2 = this.readGpsRecList(list);
        Main.pleaseWaitDlg.progress.setMaximum(list2.size());
        if (list2.size() > 0) {
            GpsRec gpsRec = null;
            GpxTrack gpxTrack = new GpxTrack();
            ArrayList<WayPoint> arrayList = new ArrayList<WayPoint>(100);
            gpxData = new GpxData();
            gpxData.tracks.add(gpxTrack);
            gpxTrack.trackSegs.add(arrayList);
            for (GpsRec gpsRec2 : list2) {
                if (this.cancelled) {
                    return gpxData;
                }
                WayPoint wayPoint = this.wayPointFrom(gpsRec2);
                if (gpsRec2.equals(gpsRec)) {
                    gpxData.waypoints.add(wayPoint);
                } else {
                    arrayList.add(wayPoint);
                }
                gpsRec = gpsRec2;
                Main.pleaseWaitDlg.progress.setValue(n++);
            }
        }
        return gpxData;
    }

    private WayPoint wayPointFrom(GpsRec gpsRec) {
        LatLon latLon = new LatLon(gpsRec.getLatitude(), gpsRec.getLongitude());
        WayPoint wayPoint = new WayPoint(latLon);
        wayPoint.attr.put("time", "" + gpsRec.getStringZuluTime());
        wayPoint.attr.put("speed", "" + gpsRec.getSpeed());
        if (gpsRec.getDg100TypeOfCurRec() > 1) {
            wayPoint.attr.put("ele", "" + gpsRec.getAltitude());
        }
        return wayPoint;
    }

    public void deleteData() throws ConnectionException {
        if (this.port == null) {
            this.connect();
        }
        try {
            Response response = this.sendCmdDelFiles();
        }
        catch (Exception exception) {
            throw new ConnectionException(exception);
        }
    }

    public void disconnect() {
        if (this.port != null) {
            this.port.close();
            this.port = null;
        }
    }

    private void connect() throws ConnectionException {
        try {
            this.port = (SerialPort)this.portIdentifier.open("DG100", 2000);
            this.port.setSerialPortParams(115200, 8, 2, 0);
            this.port.notifyOnOutputEmpty(false);
        }
        catch (PortInUseException portInUseException) {
            throw new ConnectionException(portInUseException);
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {
            throw new ConnectionException(unsupportedCommOperationException);
        }
    }

    private List<FileInfoRec> readFileInfoList() throws ConnectionException {
        int n = 0;
        ArrayList<FileInfoRec> arrayList = new ArrayList<FileInfoRec>(64);
        try {
            do {
                Response response = this.sendCmdGetFileInfo(n);
                n = response.getNextIdx();
                arrayList.addAll(response.getRecs());
            } while (n > 0);
            return arrayList;
        }
        catch (Exception exception) {
            throw new ConnectionException(exception);
        }
    }

    public List<GpsRec> readGpsRecList(List<FileInfoRec> list) throws ConnectionException {
        int n = 0;
        ArrayList<GpsRec> arrayList = new ArrayList<GpsRec>(200);
        try {
            for (FileInfoRec fileInfoRec : list) {
                ++n;
                Response response = this.sendCmdGetGpsRecs(fileInfoRec.getIdx());
                arrayList.addAll(response.getRecs());
            }
            return arrayList;
        }
        catch (Exception exception) {
            throw new ConnectionException(exception);
        }
    }

    private Response sendCmdDelFiles() throws IOException, UnsupportedCommOperationException {
        System.out.println("deleting data...");
        int n = this.sendCmd(dg100CmdDelFile, this.response, -1);
        return Response.parseResponse(this.response, n);
    }

    private Response sendCmdGetFileInfo(int n) throws IOException, UnsupportedCommOperationException {
        byte[] byArray = dg100CmdGetFileInfo;
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.position(5);
        byteBuffer.putShort((short)n);
        this.updateCheckSum(byteBuffer);
        int n2 = this.sendCmd(byArray, this.response, -1);
        return Response.parseResponse(this.response, n2);
    }

    private Response sendCmdGetConfig() throws IOException, UnsupportedCommOperationException {
        byte[] byArray = dg100CmdGetConfig;
        int n = this.sendCmd(byArray, this.response, -1);
        return Response.parseResponse(this.response, n);
    }

    public Dg100Config getConfig() throws ConnectionException {
        try {
            if (this.port == null) {
                this.connect();
            }
            Response response = this.sendCmdGetConfig();
            return response.getConfig();
        }
        catch (Exception exception) {
            throw new ConnectionException(exception);
        }
    }

    private void sendCmdSetConfig(Dg100Config dg100Config) throws IOException, UnsupportedCommOperationException {
        byte[] byArray = dg100CmdSetConfig;
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        if (dg100Config != null) {
            dg100Config.write(byteBuffer);
        }
        this.updateCheckSum(byteBuffer);
        int n = this.sendCmd(byArray, this.response, -1);
        Response.parseResponse(this.response, n);
    }

    public void setConfig(Dg100Config dg100Config) throws ConnectionException {
        try {
            this.sendCmdSetConfig(dg100Config);
        }
        catch (Exception exception) {
            throw new ConnectionException(exception);
        }
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    private Response sendCmdGetGpsRecs(int n) throws IOException, UnsupportedCommOperationException {
        byte[] byArray = dg100CmdGetGpsRecs;
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.position(5);
        byteBuffer.putShort((short)n);
        this.updateCheckSum(byteBuffer);
        int n2 = this.sendCmd(byArray, this.response, 2074);
        return Response.parseResponse(this.response, n2);
    }

    private void updateCheckSum(ByteBuffer byteBuffer) {
        byteBuffer.position(2);
        int n = byteBuffer.getShort();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += ByteHelper.byte2IntUnsigned(byteBuffer.get());
        }
        byteBuffer.putShort((short)(n2 &= Short.MAX_VALUE));
    }

    private int sendCmd(byte[] byArray, byte[] byArray2, int n) throws IOException, UnsupportedCommOperationException {
        int n2 = 0;
        OutputStream outputStream = null;
        outputStream = this.port.getOutputStream();
        outputStream.write(byArray);
        outputStream.flush();
        n2 = this.readResponse(byArray2, n);
        return n2;
    }

    private int readResponse(byte[] byArray, int n) throws IOException, UnsupportedCommOperationException {
        byte[] byArray2 = new byte[200];
        int n2 = 0;
        boolean bl = false;
        this.port.enableReceiveTimeout(2000);
        int n3 = 0;
        InputStream inputStream = this.port.getInputStream();
        if (inputStream != null) {
            int n4;
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            this.port.enableReceiveThreshold(2);
            boolean bl2 = false;
            while (!bl2) {
                byArray[0] = byArray[1];
                n4 = inputStream.read(byArray, 1, 1);
                if (n4 == 0) {
                    return 0;
                }
                bl2 = byArray[0] == -96 && byArray[1] == -94;
            }
            n2 = 2;
            n3 = 2;
            this.port.enableReceiveThreshold(2);
            while (n < 0 || n >= 0 && n3 < n) {
                n4 = 0;
                n4 = inputStream.read(byArray2);
                n2 = ByteHelper.copyByteArr2ByteArr(byArray2, 0, n4, byArray, n2);
                if (!bl && (n3 += n4) >= 4) {
                    if (n == -1) {
                        byteBuffer.position(2);
                        n = byteBuffer.getShort() + 4;
                    }
                    this.port.enableReceiveThreshold(1);
                    bl = true;
                }
                if (n4 != 0) continue;
                break;
            }
            return n3 > n ? n : n3;
        }
        return -1;
    }

    public class ConnectionException
    extends Exception {
        ConnectionException(Exception exception) {
            super(exception);
        }

        ConnectionException(String string) {
            super(string);
        }
    }
}

