/*
 * Decompiled with CFR 0.152.
 */
package org.kaintoch.gps.globalsat.dg100;

import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class GpsRec {
    private int dg100Latitude = -1;
    private int dg100Longitude = -1;
    private int dg100TimeZ = -1;
    private int dg100Date = -1;
    private int dg100Speed = -1;
    private int dg100Altitude = -1;
    private int dg100Unk1 = -1;
    private int dg100TypeOfCurRec = -1;
    private int dg100TypeOfNextRec = -1;
    private Calendar dateTime = null;

    public GpsRec() {
        this.dg100TypeOfNextRec = 2;
        this.dg100TypeOfCurRec = 2;
        this.dg100Latitude = 0;
        this.dg100Longitude = 0;
        this.dg100TimeZ = 0;
        this.dg100Date = 0;
        this.dg100Speed = 0;
        this.dg100Altitude = 0;
        this.dg100Unk1 = -1;
        this.dateTime = null;
    }

    public void copy(GpsRec gpsRec) {
        this.dg100TypeOfNextRec = gpsRec.dg100TypeOfNextRec;
        this.dg100TypeOfCurRec = gpsRec.dg100TypeOfCurRec;
        this.dg100Latitude = gpsRec.dg100Latitude;
        this.dg100Longitude = gpsRec.dg100Longitude;
        this.dg100TimeZ = gpsRec.dg100TimeZ;
        this.dg100Date = gpsRec.dg100Date;
        this.dg100Speed = gpsRec.dg100Speed;
        this.dg100Altitude = gpsRec.dg100Altitude;
        this.dg100Unk1 = gpsRec.dg100Unk1;
        this.dateTime = gpsRec.dateTime;
    }

    public GpsRec(GpsRec gpsRec) {
        this.copy(gpsRec);
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object != null && object instanceof GpsRec) {
            GpsRec gpsRec = (GpsRec)object;
            bl = this.dg100TypeOfNextRec == gpsRec.dg100TypeOfNextRec && this.dg100TypeOfCurRec == gpsRec.dg100TypeOfCurRec && this.dg100Latitude == gpsRec.dg100Latitude && this.dg100Longitude == gpsRec.dg100Longitude && this.dg100TimeZ == gpsRec.dg100TimeZ && this.dg100Date == gpsRec.dg100Date && this.dg100Speed == gpsRec.dg100Speed && this.dg100Altitude == gpsRec.dg100Altitude;
        }
        return bl;
    }

    public GpsRec(ByteBuffer byteBuffer, int n) {
        this.dg100Latitude = byteBuffer.getInt();
        this.dg100Longitude = byteBuffer.getInt();
        this.dg100TypeOfNextRec = n;
        this.dg100TypeOfCurRec = n;
        this.dateTime = null;
        if (this.dg100TypeOfNextRec >= 1) {
            this.dg100TimeZ = byteBuffer.getInt();
            this.dg100Date = byteBuffer.getInt();
            this.calcDateTime();
            this.dg100Speed = byteBuffer.getInt();
            if (this.dg100TypeOfNextRec >= 1) {
                this.dg100Altitude = byteBuffer.getInt();
                this.dg100Unk1 = byteBuffer.getInt();
                this.dg100TypeOfNextRec = byteBuffer.getInt();
            }
        }
    }

    public boolean isValid() {
        return this.dg100Latitude <= 360000000 && this.dg100Latitude >= 0 && this.dg100Longitude <= 360000000 && this.dg100Longitude >= 0 && this.dg100TimeZ >= 0 && this.dg100TimeZ <= 240000 && this.dg100Unk1 >= 0 && this.dg100Unk1 <= 1;
    }

    public int getDg100TypeOfNextRec() {
        return this.dg100TypeOfNextRec;
    }

    public int getDg100TypeOfCurRec() {
        return this.dg100TypeOfCurRec;
    }

    public String toString() {
        return "[GpsRec:  Lat = " + this.dg100Latitude + ", Long = " + this.dg100Longitude + ", TimeZ = " + this.dg100TimeZ + ", Date = " + this.dg100Date + ", Speed = " + this.dg100Speed + ", Alt = " + this.dg100Altitude + ", Unk1 = " + this.dg100Unk1 + ", TypeOfCurRec = " + this.dg100TypeOfCurRec + ", TypeOfNextRec = " + this.dg100TypeOfNextRec + "]";
    }

    public int getDg100Latitude() {
        return this.dg100Latitude;
    }

    public String toGpxTrkpt() {
        StringBuffer stringBuffer = new StringBuffer(500);
        stringBuffer.append("<trkpt");
        stringBuffer.append(" lat=\"").append(this.getLatitude()).append("\"");
        stringBuffer.append(" lon=\"").append(this.getLongitude()).append("\"");
        stringBuffer.append(">");
        if (this.dg100TypeOfCurRec > 0) {
            if (this.dg100TypeOfCurRec > 1) {
                stringBuffer.append("<ele>").append(this.getAltitude()).append("</ele>");
            }
            stringBuffer.append("<time>").append(this.getStringZuluTime()).append("</time>");
            stringBuffer.append("<speed>").append(this.getSpeed()).append("</speed>");
        }
        stringBuffer.append("</trkpt>");
        return stringBuffer.toString();
    }

    public String toGpxWpt() {
        StringBuffer stringBuffer = new StringBuffer(500);
        stringBuffer.append("<wpt");
        stringBuffer.append(" lat=\"").append(this.getLatitude()).append("\"");
        stringBuffer.append(" lon=\"").append(this.getLongitude()).append("\"");
        stringBuffer.append(">");
        if (this.dg100TypeOfCurRec > 0) {
            if (this.dg100TypeOfCurRec > 1) {
                stringBuffer.append("<ele>").append(this.getAltitude()).append("</ele>");
            }
            stringBuffer.append("<time>").append(this.getStringZuluTime()).append("</time>");
        }
        stringBuffer.append("</wpt>");
        return stringBuffer.toString();
    }

    private double toDegree(int n) {
        int n2 = 1000000;
        double d = 9999.9999;
        double d2 = n / n2;
        double d3 = ((double)n - d2 * (double)n2) / 600000.0;
        d = d2 + d3;
        return d;
    }

    public String getStringZuluTime() {
        return this.getStringDateTime("yyyy-MM-dd'T'HH:mm:ss'Z'");
    }

    public String getStringDateTime() {
        return this.getStringDateTime("yyyyMMddHHmmss");
    }

    private String getStringDateTime(String string) {
        String string2 = "???";
        if (this.dateTime != null) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
            string2 = simpleDateFormat.format(this.dateTime.getTime());
        }
        return string2;
    }

    public int getDg100Altitude() {
        return this.dg100Altitude;
    }

    private void setDg100Altitude(int n) {
        this.dg100Altitude = n;
    }

    public int getDg100Date() {
        return this.dg100Date;
    }

    private void setDg100Date(int n) {
        this.dg100Date = n;
        this.calcDateTime();
    }

    private void calcDateTime() {
        int n = this.dg100TimeZ / 10000;
        int n2 = (this.dg100TimeZ - n * 10000) / 100;
        int n3 = this.dg100TimeZ - n * 10000 - n2 * 100;
        int n4 = this.dg100Date / 10000;
        int n5 = (this.dg100Date - n4 * 10000) / 100;
        int n6 = this.dg100Date - n4 * 10000 - n5 * 100;
        this.dateTime = GregorianCalendar.getInstance();
        this.dateTime.set(2000 + n6, n5, n4, n, n2, n3);
    }

    public int getDg100Longitude() {
        return this.dg100Longitude;
    }

    private void setDg100Longitude(int n) {
        this.dg100Longitude = n;
    }

    public int getDg100Speed() {
        return this.dg100Speed;
    }

    private void setDg100Speed(int n) {
        this.dg100Speed = n;
    }

    public int getDg100TimeZ() {
        return this.dg100TimeZ;
    }

    private void setDg100TimeZ(int n) {
        this.dg100TimeZ = n;
        this.calcDateTime();
    }

    private void setDg100Latitude(int n) {
        this.dg100Latitude = n;
    }

    public void updateMin(GpsRec gpsRec) {
        if (gpsRec != null) {
            if (gpsRec.getDg100Latitude() < this.getDg100Latitude()) {
                this.setDg100Latitude(gpsRec.getDg100Latitude());
            }
            if (gpsRec.getDg100Longitude() < this.getDg100Longitude()) {
                this.setDg100Longitude(gpsRec.getDg100Longitude());
            }
            if (gpsRec.getDg100Altitude() < this.getDg100Altitude()) {
                this.setDg100Altitude(gpsRec.getDg100Altitude());
            }
            if (gpsRec.getDg100Date() < this.getDg100Date() || gpsRec.getDg100Date() == this.getDg100Date() && gpsRec.getDg100TimeZ() < this.getDg100TimeZ()) {
                this.setDg100Date(gpsRec.getDg100Date());
                this.setDg100TimeZ(gpsRec.getDg100TimeZ());
            }
            if (gpsRec.getDg100Speed() < this.getDg100Speed()) {
                this.setDg100Speed(gpsRec.getDg100Speed());
            }
        }
    }

    public void updateMax(GpsRec gpsRec) {
        if (gpsRec != null) {
            if (gpsRec.getDg100Latitude() > this.getDg100Latitude()) {
                this.setDg100Latitude(gpsRec.getDg100Latitude());
            }
            if (gpsRec.getDg100Longitude() > this.getDg100Longitude()) {
                this.setDg100Longitude(gpsRec.getDg100Longitude());
            }
            if (gpsRec.getDg100Altitude() > this.getDg100Altitude()) {
                this.setDg100Altitude(gpsRec.getDg100Altitude());
            }
            if (gpsRec.getDg100Date() > this.getDg100Date() || gpsRec.getDg100Date() == this.getDg100Date() && gpsRec.getDg100TimeZ() > this.getDg100TimeZ()) {
                this.setDg100Date(gpsRec.getDg100Date());
                this.setDg100TimeZ(gpsRec.getDg100TimeZ());
            }
            if (gpsRec.getDg100Speed() > this.getDg100Speed()) {
                this.setDg100Speed(gpsRec.getDg100Speed());
            }
        }
    }

    public Calendar getDateTime() {
        return this.dateTime;
    }

    public double getLatitude() {
        return this.toDegree(this.dg100Latitude);
    }

    public double getLongitude() {
        return this.toDegree(this.dg100Longitude);
    }

    public double getAltitude() {
        return (double)this.dg100Altitude / 10000.0;
    }

    public double getSpeed() {
        return (double)this.dg100Speed / 360.0;
    }
}

