/*
 * Decompiled with CFR 0.152.
 */
package at.dallermassl.josm.plugin.pluginmanager;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;

public class PluginResource {
    private static final int BUFFER_SIZE = 16384;
    private URL resourceUrl;
    private String target;
    private String errorMessage;
    private Exception errorException;

    public URL getResourceUrl() {
        return this.resourceUrl;
    }

    public void setResourceUrl(URL resourceUrl) {
        this.resourceUrl = resourceUrl;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public Exception getErrorException() {
        return this.errorException;
    }

    public void setErrorException(Exception errorException) {
        this.errorException = errorException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void install() {
        File parentDir;
        File targetFile = new File(this.target);
        if (targetFile.isDirectory() || targetFile.getAbsolutePath().endsWith("/") || targetFile.getAbsolutePath().endsWith("\\")) {
            targetFile = new File(targetFile, this.resourceUrl.getFile());
        }
        if (!(parentDir = targetFile.getParentFile()).exists() && !parentDir.mkdirs()) {
            this.errorMessage = "Could not create the target directory: " + parentDir.getAbsolutePath();
            return;
        }
        System.out.println("Install " + this.resourceUrl + " to " + targetFile);
        byte[] buffer = new byte[16384];
        InputStream in = null;
        OutputStream out = null;
        try {
            int read;
            in = this.resourceUrl.openConnection().getInputStream();
            out = new BufferedOutputStream(new FileOutputStream(targetFile));
            while ((read = in.read(buffer)) >= 0) {
                out.write(buffer, 0, read);
            }
        }
        catch (IOException e) {
            this.errorMessage = e.getMessage();
            this.errorException = e;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ignore) {}
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ignore) {}
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[url=" + this.resourceUrl + ", target=" + this.target + "]";
    }
}

