/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.measurement;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.measurement.MeasurementPlugin;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class MeasurementLayer
extends Layer {
    private static Icon icon = new ImageIcon(Toolkit.getDefaultToolkit().createImage(MeasurementPlugin.class.getResource("/images/measurement.png")));
    private Collection<WayPoint> points = new ArrayList<WayPoint>(32);

    public MeasurementLayer(String string) {
        super(string);
    }

    public Icon getIcon() {
        return icon;
    }

    public String getToolTipText() {
        return I18n.tr((String)"Layer to make measurements");
    }

    public boolean isMergable(Layer layer) {
        return false;
    }

    public void mergeFrom(Layer layer) {
    }

    public void paint(Graphics graphics, MapView mapView) {
        graphics.setColor(Color.green);
        Point point = null;
        for (WayPoint wayPoint : this.points) {
            LatLon latLon = wayPoint.latlon;
            Point point2 = Main.map.mapView.getPoint(Main.proj.latlon2eastNorth(latLon));
            if (point != null) {
                graphics.drawLine(point.x, point.y, point2.x, point2.y);
            }
            graphics.drawOval(point2.x - 2, point2.y - 2, 4, 4);
            point = point2;
        }
    }

    public void visitBoundingBox(BoundingXYVisitor boundingXYVisitor) {
    }

    public Object getInfoComponent() {
        return this.getToolTipText();
    }

    public Component[] getMenuEntries() {
        return new Component[]{new JMenuItem((Action)new LayerListDialog.ShowHideLayerAction((Layer)this)), new JSeparator(), new JMenuItem(new GPXLayerImportAction(this)), new JSeparator(), new JMenuItem((Action)new LayerListPopup.InfoAction((Layer)this))};
    }

    public void removeLastPoint() {
        WayPoint wayPoint = null;
        Iterator<WayPoint> iterator = this.points.iterator();
        while (iterator.hasNext()) {
            WayPoint wayPoint2;
            wayPoint = wayPoint2 = iterator.next();
        }
        if (wayPoint != null) {
            this.points.remove(wayPoint);
        }
        this.recalculate();
        Main.map.repaint();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() != 1) {
            return;
        }
        LatLon latLon = Main.map.mapView.getLatLon(mouseEvent.getX(), mouseEvent.getY());
        this.points.add(new WayPoint(latLon));
        Main.map.repaint();
        this.recalculate();
    }

    public void reset() {
        this.points.clear();
        this.recalculate();
        Main.map.repaint();
    }

    private void recalculate() {
        double d = 0.0;
        double d2 = 0.0;
        WayPoint wayPoint = null;
        d = 0.0;
        for (WayPoint object2 : this.points) {
            if (wayPoint != null) {
                d2 = MeasurementLayer.calcDistance(wayPoint, object2);
                d += d2;
            }
            wayPoint = object2;
        }
        DecimalFormat decimalFormat = new DecimalFormat("#0.00");
        DecimalFormat decimalFormat2 = new DecimalFormat("#0.0");
        MeasurementPlugin.measurementDialog.pathLengthLabel.setText(d < 800.0 ? decimalFormat2.format(d) + " m" : decimalFormat.format(d / 1000.0) + " km");
    }

    public static double calcDistance(LatLon latLon, LatLon latLon2) {
        double d = latLon.lat() * Math.PI / 180.0;
        double d2 = latLon.lon() * Math.PI / 180.0;
        double d3 = latLon2.lat() * Math.PI / 180.0;
        double d4 = latLon2.lon() * Math.PI / 180.0;
        double d5 = d4 - d2;
        double d6 = d3 - d;
        double d7 = Math.pow(Math.sin(d6 / 2.0), 2.0) + Math.cos(d) * Math.cos(d3) * Math.pow(Math.sin(d5 / 2.0), 2.0);
        double d8 = 2.0 * Math.atan2(Math.sqrt(d7), Math.sqrt(1.0 - d7));
        return 6367000.0 * d8;
    }

    public static double calcX(LatLon latLon) {
        double d = latLon.lat() * Math.PI / 180.0;
        double d2 = latLon.lon() * Math.PI / 180.0;
        double d3 = d;
        double d4 = 0.0;
        double d5 = d4 - d2;
        double d6 = d3 - d;
        double d7 = Math.pow(Math.sin(d6 / 2.0), 2.0) + Math.cos(d) * Math.cos(d3) * Math.pow(Math.sin(d5 / 2.0), 2.0);
        double d8 = 2.0 * Math.atan2(Math.sqrt(d7), Math.sqrt(1.0 - d7));
        return 6367000.0 * d8;
    }

    public static double calcY(LatLon latLon) {
        double d = latLon.lat() * Math.PI / 180.0;
        double d2 = latLon.lon() * Math.PI / 180.0;
        double d3 = 0.0;
        double d4 = d2;
        double d5 = d4 - d2;
        double d6 = d3 - d;
        double d7 = Math.pow(Math.sin(d6 / 2.0), 2.0) + Math.cos(d) * Math.cos(d3) * Math.pow(Math.sin(d5 / 2.0), 2.0);
        double d8 = 2.0 * Math.atan2(Math.sqrt(d7), Math.sqrt(1.0 - d7));
        return 6367000.0 * d8;
    }

    public static double calcDistance(WayPoint wayPoint, WayPoint wayPoint2) {
        return MeasurementLayer.calcDistance(wayPoint.latlon, wayPoint2.latlon);
    }

    public static double angleBetween(WayPoint wayPoint, WayPoint wayPoint2) {
        return MeasurementLayer.angleBetween(wayPoint.latlon, wayPoint2.latlon);
    }

    public static double angleBetween(LatLon latLon, LatLon latLon2) {
        double d = latLon.lat() * Math.PI / 180.0;
        double d2 = latLon.lon() * Math.PI / 180.0;
        double d3 = latLon2.lat() * Math.PI / 180.0;
        double d4 = latLon2.lon() * Math.PI / 180.0;
        double d5 = d4 - d2;
        double d6 = Math.cos(d3);
        return 180.0 * Math.atan2(d6 * Math.sin(d5), Math.cos(d) * Math.sin(d3) - Math.sin(d) * d6 * Math.cos(d5)) / Math.PI;
    }

    public static double OldangleBetween(LatLon latLon, LatLon latLon2) {
        double d = latLon.lat() * Math.PI / 180.0;
        double d2 = latLon.lon() * Math.PI / 180.0;
        double d3 = latLon2.lat() * Math.PI / 180.0;
        double d4 = latLon2.lon() * Math.PI / 180.0;
        double d5 = d4 - d2;
        double d6 = d3 - d;
        double d7 = Math.pow(Math.sin(d6 / 2.0), 2.0) + Math.cos(d) * Math.cos(d3) * Math.pow(Math.sin(d5 / 2.0), 2.0);
        double d8 = 2.0 * Math.atan2(Math.sqrt(d7), Math.sqrt(1.0 - d7));
        double d9 = Math.acos((Math.sin(d3) - Math.sin(d) * Math.cos(d8)) / (Math.sin(d8) * Math.cos(d)));
        if (Math.sin(d4 - d2) < 0.0) {
            d9 = Math.PI * 2 - d9;
        }
        return d9 * 180.0 / Math.PI;
    }

    private class GPXLayerImportAction
    extends AbstractAction {
        private MeasurementLayer layer;
        private DefaultListModel model;

        public GPXLayerImportAction(MeasurementLayer measurementLayer2) {
            super(I18n.tr((String)"Import path from GPX layer"), ImageProvider.get((String)"dialogs", (String)"edit"));
            this.model = new DefaultListModel();
            this.layer = measurementLayer2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Box box = Box.createVerticalBox();
            final JList<Object> jList = new JList<Object>(this.model);
            Collection collection = Main.map.mapView.getAllLayers();
            Layer layer = null;
            int n = 0;
            for (Object object : collection) {
                if (!(object instanceof GpxLayer)) continue;
                this.model.addElement(object);
                layer = object;
                ++n;
            }
            if (n == 1) {
                jList.setSelectedValue(layer, true);
            }
            if (n > 0) {
                Object object;
                jList.setCellRenderer(new DefaultListCellRenderer(){

                    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                        Layer layer = (Layer)object;
                        JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, layer.name, n, bl, bl2);
                        Icon icon = layer.getIcon();
                        jLabel.setIcon(icon);
                        jLabel.setToolTipText(layer.getToolTipText());
                        return jLabel;
                    }
                });
                JCheckBox jCheckBox = new JCheckBox(I18n.tr((String)"Drop existing path"));
                box.add(jList);
                box.add(jCheckBox);
                object = new JOptionPane(box, 3, 2){

                    public void selectInitialValue() {
                        jList.requestFocusInWindow();
                    }
                };
                JDialog jDialog = ((JOptionPane)object).createDialog(Main.parent, I18n.tr((String)"Import path from GPX layer"));
                jDialog.setVisible(true);
                Object object2 = ((JOptionPane)object).getValue();
                if (object2 == null || object2 == JOptionPane.UNINITIALIZED_VALUE || object2 instanceof Integer && (Integer)object2 != 0) {
                    return;
                }
                GpxLayer gpxLayer = (GpxLayer)jList.getSelectedValue();
                if (jCheckBox.isSelected()) {
                    MeasurementLayer.this.points = new ArrayList(32);
                }
                for (GpxTrack gpxTrack : gpxLayer.data.tracks) {
                    for (Collection collection2 : gpxTrack.trackSegs) {
                        for (WayPoint wayPoint : collection2) {
                            MeasurementLayer.this.points.add(wayPoint);
                        }
                    }
                }
                MeasurementLayer.this.recalculate();
                Main.parent.repaint();
            } else {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"No GPX data layer found."));
            }
        }
    }
}

