/*
 * Decompiled with CFR 0.152.
 */
package waypoints;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class WaypointReader {
    public static DataSet parse(InputStream source) throws SAXException, IOException, ParserConfigurationException {
        Parser parser = new Parser();
        SAXParserFactory.newInstance().newSAXParser().parse(new InputSource(new InputStreamReader(source, "UTF-8")), (DefaultHandler)parser);
        return parser.dataSet;
    }

    private static class Parser
    extends DefaultHandler {
        private DataSet dataSet = new DataSet();
        private LatLon currentLatLon;
        private String curWptName;
        private boolean inName = false;

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if (qName.equals("wpt")) {
                try {
                    double lat = Double.parseDouble(atts.getValue("lat"));
                    double lon = Double.parseDouble(atts.getValue("lon"));
                    if (Math.abs(lat) > 90.0) {
                        throw new SAXException(I18n.tr((String)"Data error: lat value \"{0}\" is out of bound.", (Object[])new Object[]{lat}));
                    }
                    if (Math.abs(lon) > 180.0) {
                        throw new SAXException(I18n.tr((String)"Data error: lon value \"{0}\" is out of bound.", (Object[])new Object[]{lon}));
                    }
                    this.currentLatLon = new LatLon(lat, lon);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                    throw new SAXException(e);
                }
            } else if (qName.equals("name")) {
                this.inName = true;
                this.curWptName = "";
            }
        }

        public void characters(char[] ch, int start, int length) {
            if (this.inName) {
                this.curWptName = new String(ch, start, length);
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) {
            if (qName.equals("wpt") && this.curWptName != "") {
                System.out.println("Found a waypoint to convert to a node: " + this.curWptName);
                Node node = new Node(this.currentLatLon);
                node.put("name", this.curWptName);
                this.dataSet.nodes.add(node);
            } else if (qName.equals("name")) {
                this.inName = false;
            }
        }
    }
}

