/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.osb.api.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.plugins.osb.api.util.HttpResponse;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpUtils {
    public static String get(String url, Map<String, String> headers, String charset) throws IOException {
        URL page = new URL(url);
        URLConnection con = page.openConnection();
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                con.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int length = -1;
        byte[] b = new byte[1024];
        InputStream in = con.getInputStream();
        while ((length = in.read(b)) > 0) {
            bos.write(b, 0, length);
        }
        return new String(bos.toByteArray(), charset);
    }

    public static HttpResponse getResponse(String url, Map<String, String> headers, String charset) throws IOException {
        URL page = new URL(url);
        URLConnection con = page.openConnection();
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                con.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int length = -1;
        byte[] b = new byte[1024];
        InputStream in = con.getInputStream();
        while ((length = in.read(b)) > 0) {
            bos.write(b, 0, length);
        }
        HttpResponse response = new HttpResponse(new String(bos.toByteArray(), charset), con.getHeaderFields());
        return response;
    }

    public static String post(String url, Map<String, String> headers, String content, String responseCharset) throws IOException {
        URL page = new URL(url);
        URLConnection con = page.openConnection();
        con.setDoOutput(true);
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                con.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        OutputStream os = con.getOutputStream();
        os.write(content.getBytes("UTF-8"));
        os.flush();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int length = -1;
        byte[] b = new byte[1024];
        InputStream in = con.getInputStream();
        while ((length = in.read(b)) > 0) {
            bos.write(b, 0, length);
        }
        return new String(bos.toByteArray(), responseCharset);
    }

    public static String addParameter(String uri, String param, String value) {
        StringBuilder sb = new StringBuilder(uri);
        if (uri.contains("?")) {
            sb.append('&');
        } else {
            sb.append('?');
        }
        sb.append(param);
        sb.append('=');
        sb.append(value);
        return sb.toString();
    }

    public static Map<String, List<String>> head(String url, Map<String, String> headers, String charset) throws IOException {
        URL page = new URL(url);
        URLConnection con = page.openConnection();
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                con.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        return con.getHeaderFields();
    }

    public static String getHeaderField(Map<String, List<String>> headers, String headerField) {
        if (!headers.containsKey(headerField)) {
            return null;
        }
        List<String> value = headers.get(headerField);
        if (value.size() == 1) {
            return value.get(0);
        }
        throw new RuntimeException(I18n.tr((String)"Header contains several values and cannot be mapped to a single String"));
    }
}

