/*
 * Decompiled with CFR 0.152.
 */
package nearclick;

import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.GraphicsEnvironment;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import org.openstreetmap.josm.Main;

public class NearClickPlugin
implements AWTEventListener {
    private int mouseDownX = -1;
    private int mouseDownY = -1;
    private long mouseDownTime = -1L;
    private int radiussquared = 49;
    private int delay = 250;

    public NearClickPlugin() {
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 48L);
        try {
            int radius = Integer.parseInt(Main.pref.get("nearclick.radius", "7"));
            this.radiussquared = radius * radius;
            this.delay = Integer.parseInt(Main.pref.get("nearclick.delay", "250"));
        }
        catch (NumberFormatException ex) {
            this.delay = 250;
            this.radiussquared = 49;
        }
    }

    public void eventDispatched(AWTEvent event) {
        if (event instanceof MouseEvent) {
            MouseEvent e = (MouseEvent)event;
            if (e.getButton() != 1) {
                return;
            }
            int xdiff = e.getPoint().x - this.mouseDownX;
            int ydiff = e.getPoint().y - this.mouseDownY;
            if (e.getID() == 502 && e.getWhen() - this.mouseDownTime < (long)this.delay && (e.getPoint().x != this.mouseDownX || e.getPoint().y != this.mouseDownY) && xdiff * xdiff + ydiff * ydiff < this.radiussquared) {
                try {
                    Robot r = new Robot(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice());
                    r.mousePress(16);
                    r.mouseRelease(16);
                }
                catch (AWTException e1) {
                    // empty catch block
                }
            }
            if (e.getID() == 501) {
                this.mouseDownX = e.getPoint().x;
                this.mouseDownY = e.getPoint().y;
                this.mouseDownTime = e.getWhen();
            }
        }
    }
}

