/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.agpifoj;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.plugins.agpifoj.AgpifojLayer;
import org.openstreetmap.josm.plugins.agpifoj.ImageDisplay;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class AgpifojDialog
extends ToggleDialog
implements ActionListener {
    private static final String COMMAND_ZOOM = "zoom";
    private static final String COMMAND_CENTERVIEW = "centre";
    private static final String COMMAND_NEXT = "next";
    private static final String COMMAND_REMOVE = "remove";
    private static final String COMMAND_PREVIOUS = "previous";
    private ImageDisplay imgDisplay = new ImageDisplay();
    private boolean centerView = false;
    private static AgpifojDialog INSTANCE = null;
    private AgpifojLayer currentLayer = null;
    private AgpifojLayer.ImageEntry currentEntry = null;

    public static AgpifojDialog getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AgpifojDialog();
        }
        return INSTANCE;
    }

    private AgpifojDialog() {
        super(I18n.tr((String)"AgPifoJ - Geotagged pictures"), "agpifoj", I18n.tr((String)"Display geotagged photos"), Shortcut.registerShortcut((String)"tools:geotagged", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Display geotagged photos")}), (int)89, (int)3), 200);
        if (INSTANCE != null) {
            throw new IllegalStateException("Agpifoj dialog should not be instanciated twice !");
        }
        INSTANCE = this;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.imgDisplay, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout());
        Dimension dimension = new Dimension(26, 26);
        JButton jButton = new JButton();
        jButton.setIcon(ImageProvider.get((String)"dialogs", (String)COMMAND_PREVIOUS));
        jButton.setActionCommand(COMMAND_PREVIOUS);
        jButton.setToolTipText(I18n.tr((String)"Previous"));
        jButton.addActionListener(this);
        jButton.setPreferredSize(dimension);
        jPanel2.add(jButton);
        jButton = new JButton();
        jButton.setIcon(ImageProvider.get((String)"dialogs", (String)"delete"));
        jButton.setActionCommand(COMMAND_REMOVE);
        jButton.setToolTipText(I18n.tr((String)"Remove photo from layer"));
        jButton.addActionListener(this);
        jButton.setPreferredSize(dimension);
        jPanel2.add(jButton);
        jButton = new JButton();
        jButton.setIcon(ImageProvider.get((String)"dialogs", (String)COMMAND_NEXT));
        jButton.setActionCommand(COMMAND_NEXT);
        jButton.setToolTipText(I18n.tr((String)"Next"));
        jButton.addActionListener(this);
        jButton.setPreferredSize(dimension);
        jPanel2.add(jButton);
        JToggleButton jToggleButton = new JToggleButton();
        jToggleButton.setIcon(ImageProvider.get((String)"dialogs", (String)"centreview"));
        jToggleButton.setActionCommand(COMMAND_CENTERVIEW);
        jToggleButton.setToolTipText(I18n.tr((String)"Center view"));
        jToggleButton.addActionListener(this);
        jToggleButton.setPreferredSize(dimension);
        jPanel2.add(jToggleButton);
        jButton = new JButton();
        jButton.setIcon(ImageProvider.get((String)"dialogs", (String)"zoom-best-fit"));
        jButton.setActionCommand(COMMAND_ZOOM);
        jButton.setToolTipText(I18n.tr((String)"Zoom best fit and 1:1"));
        jButton.addActionListener(this);
        jButton.setPreferredSize(dimension);
        jPanel2.add(jButton);
        jPanel.add((Component)jPanel2, "South");
        this.add(jPanel, "Center");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (COMMAND_NEXT.equals(actionEvent.getActionCommand())) {
            if (this.currentLayer != null) {
                this.currentLayer.showNextPhoto();
            }
        } else if (COMMAND_PREVIOUS.equals(actionEvent.getActionCommand())) {
            if (this.currentLayer != null) {
                this.currentLayer.showPreviousPhoto();
            }
        } else if (COMMAND_CENTERVIEW.equals(actionEvent.getActionCommand())) {
            this.centerView = ((JToggleButton)actionEvent.getSource()).isSelected();
            if (this.centerView && this.currentEntry != null && this.currentEntry.pos != null) {
                Main.map.mapView.zoomTo(this.currentEntry.pos, Main.map.mapView.getScale());
            }
        } else if (COMMAND_ZOOM.equals(actionEvent.getActionCommand())) {
            this.imgDisplay.zoomBestFitOrOne();
        } else if (COMMAND_REMOVE.equals(actionEvent.getActionCommand()) && this.currentLayer != null) {
            this.currentLayer.removeCurrentPhoto();
        }
    }

    public static void showImage(AgpifojLayer agpifojLayer, AgpifojLayer.ImageEntry imageEntry) {
        AgpifojDialog.getInstance().displayImage(agpifojLayer, imageEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayImage(AgpifojLayer agpifojLayer, AgpifojLayer.ImageEntry imageEntry) {
        Object object = this;
        synchronized (object) {
            if (this.currentLayer == agpifojLayer && this.currentEntry == imageEntry) {
                this.repaint();
                return;
            }
            if (this.centerView && Main.map != null && imageEntry != null && imageEntry.pos != null) {
                Main.map.mapView.zoomTo(imageEntry.pos, Main.map.mapView.getScale());
            }
            this.currentLayer = agpifojLayer;
            this.currentEntry = imageEntry;
        }
        this.imgDisplay.setImage(imageEntry != null ? imageEntry.file : null);
        object = new StringBuffer(imageEntry.file.getName());
        if (imageEntry.elevation != null) {
            ((StringBuffer)object).append(I18n.tr((String)"\nAltitude: ")).append(imageEntry.elevation.longValue()).append(" m");
        }
        if (imageEntry.speed != null) {
            ((StringBuffer)object).append("\n").append((long)(3.6 * imageEntry.speed)).append(I18n.tr((String)" km/h"));
        }
        this.imgDisplay.setOsdText(((StringBuffer)object).toString());
    }
}

