/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.globalsat;

import gnu.io.CommPortIdentifier;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.kaintoch.gps.globalsat.dg100.Dg100Config;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.I18n;

public class GlobalsatConfigDialog
extends JPanel {
    private JOptionPane optionPane;
    private JCheckBox delete;
    private JComboBox portCombo;
    private JRadioButton formatPosOnly = new JRadioButton(I18n.tr((String)"Position only"));
    private JRadioButton formatPosTDS = new JRadioButton(I18n.tr((String)"Position, Time, Date, Speed"));
    private JRadioButton formatPosTDSA = new JRadioButton(I18n.tr((String)"Position, Time, Date, Speed, Altitude"));
    private JRadioButton aTime = new JRadioButton(I18n.tr((String)"A By Time"));
    private JRadioButton aDist = new JRadioButton(I18n.tr((String)"A By Distance"));
    private JRadioButton bTime = new JRadioButton(I18n.tr((String)"B By Time"));
    private JRadioButton bDist = new JRadioButton(I18n.tr((String)"B By Distance"));
    private JRadioButton cTime = new JRadioButton(I18n.tr((String)"C By Time"));
    private JRadioButton cDist = new JRadioButton(I18n.tr((String)"C By Distance"));
    private JTextField aSeconds = new IntegerTextField();
    private JTextField aMeters = new IntegerTextField();
    private JTextField bSeconds = new IntegerTextField();
    private JTextField bMeters = new IntegerTextField();
    private JTextField cSeconds = new IntegerTextField();
    private JTextField cMeters = new IntegerTextField();
    private JLabel memUsage = new JLabel();
    private JCheckBox disableLogDist;
    private JCheckBox disableLogSpeed;
    private JTextField minLogDist;
    private JTextField minLogSpeed;
    private List<CommPortIdentifier> ports = new LinkedList<CommPortIdentifier>();
    private Dg100Config conf;

    public GlobalsatConfigDialog(Dg100Config dg100Config) {
        this.conf = dg100Config;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        System.out.println("read config " + dg100Config);
        Dimension dimension = this.aSeconds.getPreferredSize();
        this.aSeconds.setPreferredSize(new Dimension((int)dimension.getWidth() + 50, (int)dimension.getHeight()));
        this.aSeconds.setHorizontalAlignment(4);
        this.aMeters.setPreferredSize(new Dimension((int)dimension.getWidth() + 50, (int)dimension.getHeight()));
        this.aMeters.setHorizontalAlignment(4);
        this.bSeconds.setPreferredSize(new Dimension((int)dimension.getWidth() + 50, (int)dimension.getHeight()));
        this.bSeconds.setHorizontalAlignment(4);
        this.bMeters.setPreferredSize(new Dimension((int)dimension.getWidth() + 50, (int)dimension.getHeight()));
        this.bMeters.setHorizontalAlignment(4);
        this.cSeconds.setPreferredSize(new Dimension((int)dimension.getWidth() + 50, (int)dimension.getHeight()));
        this.cSeconds.setHorizontalAlignment(4);
        this.cMeters.setPreferredSize(new Dimension((int)dimension.getWidth() + 50, (int)dimension.getHeight()));
        this.cMeters.setHorizontalAlignment(4);
        this.setLayout(new GridBagLayout());
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.formatPosOnly);
        buttonGroup.add(this.formatPosTDS);
        buttonGroup.add(this.formatPosTDSA);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        jPanel.add(new JLabel(I18n.tr((String)"Data Logging Format")));
        jPanel.add(this.formatPosOnly);
        jPanel.add(this.formatPosTDS);
        jPanel.add(this.formatPosTDSA);
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        this.add(jPanel);
        this.disableLogSpeed = new JCheckBox(I18n.tr((String)"Disable data logging if speed falls below"));
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.disableLogSpeed, gridBagConstraints);
        this.minLogSpeed = new IntegerTextField();
        this.minLogSpeed.setHorizontalAlignment(4);
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.minLogSpeed, gridBagConstraints);
        this.disableLogSpeed.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GlobalsatConfigDialog.this.minLogSpeed.setEnabled(GlobalsatConfigDialog.this.disableLogSpeed.isSelected());
            }
        });
        this.disableLogDist = new JCheckBox(I18n.tr((String)"Disable data logging if distance falls below"));
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.add((Component)this.disableLogDist, gridBagConstraints);
        this.minLogDist = new IntegerTextField();
        this.minLogDist.setHorizontalAlignment(4);
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        this.add((Component)this.minLogDist, gridBagConstraints);
        Dimension dimension2 = this.minLogDist.getPreferredSize();
        this.minLogDist.setPreferredSize(new Dimension((int)dimension2.getWidth() + 50, (int)dimension2.getHeight()));
        this.disableLogDist.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GlobalsatConfigDialog.this.minLogDist.setEnabled(GlobalsatConfigDialog.this.disableLogDist.isSelected());
            }
        });
        this.disableLogDist.setSelected(this.conf.getDisableLogDist());
        this.disableLogSpeed.setSelected(this.conf.getDisableLogSpeed());
        this.minLogDist.setEnabled(this.disableLogDist.isSelected());
        this.minLogSpeed.setEnabled(this.disableLogSpeed.isSelected());
        this.minLogSpeed.setText("" + this.conf.getSpeedThres());
        this.minLogDist.setText("" + this.conf.getDistThres());
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.aTime);
        buttonGroup2.add(this.aDist);
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        this.add((Component)this.aTime, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        gridBagConstraints.gridy = 4;
        this.add((Component)this.aDist, gridBagConstraints);
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        this.add((Component)this.aSeconds, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        gridBagConstraints.gridy = 4;
        this.add((Component)this.aMeters, gridBagConstraints);
        buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.bTime);
        buttonGroup2.add(this.bDist);
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        this.add((Component)this.bTime, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        gridBagConstraints.gridy = 6;
        this.add((Component)this.bDist, gridBagConstraints);
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        this.add((Component)this.bSeconds, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        gridBagConstraints.gridy = 6;
        this.add((Component)this.bMeters, gridBagConstraints);
        buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.cTime);
        buttonGroup2.add(this.cDist);
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        this.add((Component)this.cTime, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        gridBagConstraints.gridy = 8;
        this.add((Component)this.cDist, gridBagConstraints);
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        this.add((Component)this.cSeconds, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        gridBagConstraints.gridy = 8;
        this.add((Component)this.cMeters, gridBagConstraints);
        switch (this.conf.getLogFormat()) {
            case 0: {
                this.formatPosOnly.setSelected(true);
                break;
            }
            case 1: {
                this.formatPosTDS.setSelected(true);
                break;
            }
            case 2: {
                this.formatPosTDSA.setSelected(true);
                break;
            }
            default: {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Unknown logFormat"));
            }
        }
        if (this.conf.getSwATimeOrDist() == 0) {
            this.aTime.setSelected(true);
            this.aDist.setSelected(false);
        } else {
            this.aTime.setSelected(false);
            this.aDist.setSelected(true);
        }
        if (this.conf.getSwBTimeOrDist() == 0) {
            this.bTime.setSelected(true);
            this.bDist.setSelected(false);
        } else {
            this.bTime.setSelected(false);
            this.bDist.setSelected(true);
        }
        if (this.conf.getSwCTimeOrDist() == 0) {
            this.cTime.setSelected(true);
            this.cDist.setSelected(false);
        } else {
            this.cTime.setSelected(false);
            this.cDist.setSelected(true);
        }
        this.aSeconds.setText("" + this.conf.getSwATime() / 1000);
        this.aMeters.setText("" + this.conf.getSwADist());
        this.bSeconds.setText("" + this.conf.getSwBTime() / 1000);
        this.bMeters.setText("" + this.conf.getSwBDist());
        this.cSeconds.setText("" + this.conf.getSwCTime() / 1000);
        this.cMeters.setText("" + this.conf.getSwCDist());
    }

    public void setOptionPane(JOptionPane jOptionPane) {
        this.optionPane = jOptionPane;
    }

    public Dg100Config getConfig() {
        this.conf.setDisableLogDist(this.disableLogDist.isSelected());
        this.conf.setDisableLogSpeed(this.disableLogSpeed.isSelected());
        this.conf.setDistThres(Integer.parseInt(this.minLogDist.getText()));
        this.conf.setSpeedThres(Integer.parseInt(this.minLogSpeed.getText()));
        if (this.formatPosOnly.isSelected()) {
            this.conf.setLogFormat((byte)0);
        } else if (this.formatPosTDS.isSelected()) {
            this.conf.setLogFormat((byte)1);
        } else if (this.formatPosTDSA.isSelected()) {
            this.conf.setLogFormat((byte)2);
        }
        this.conf.setSwATimeOrDist((byte)(this.aDist.isSelected() ? 1 : 0));
        this.conf.setSwBTimeOrDist((byte)(this.bDist.isSelected() ? 1 : 0));
        this.conf.setSwCTimeOrDist((byte)(this.cDist.isSelected() ? 1 : 0));
        this.conf.setSwATime(Integer.parseInt(this.aSeconds.getText()) * 1000);
        this.conf.setSwADist(Integer.parseInt(this.aMeters.getText()));
        this.conf.setSwBTime(Integer.parseInt(this.bSeconds.getText()) * 1000);
        this.conf.setSwBDist(Integer.parseInt(this.bMeters.getText()));
        this.conf.setSwCTime(Integer.parseInt(this.cSeconds.getText()) * 1000);
        this.conf.setSwCDist(Integer.parseInt(this.cMeters.getText()));
        return this.conf;
    }

    public class IntegerTextField
    extends JTextField {
        static final String badchars = "-`~!@#$%^&*()_+=\\|\"':;?/>.<, ";

        public void processKeyEvent(KeyEvent keyEvent) {
            char c = keyEvent.getKeyChar();
            if (Character.isLetter(c) && !keyEvent.isAltDown() || badchars.indexOf(c) > -1) {
                keyEvent.consume();
                return;
            }
            super.processKeyEvent(keyEvent);
        }
    }
}

