/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

public class OsmMercator {
    private static int TILE_SIZE = 256;
    public static final double MAX_LAT = 85.05112877980659;
    public static final double MIN_LAT = -85.05112877980659;

    public static double radius(int aZoomlevel) {
        return (double)(TILE_SIZE * (1 << aZoomlevel)) / (Math.PI * 2);
    }

    public static int getMaxPixels(int aZoomlevel) {
        return TILE_SIZE * (1 << aZoomlevel);
    }

    public static int falseEasting(int aZoomlevel) {
        return OsmMercator.getMaxPixels(aZoomlevel) / 2;
    }

    public static int falseNorthing(int aZoomlevel) {
        return -1 * OsmMercator.getMaxPixels(aZoomlevel) / 2;
    }

    public static int LonToX(double aLongitude, int aZoomlevel) {
        double longitude = Math.toRadians(aLongitude);
        int x = (int)(OsmMercator.radius(aZoomlevel) * longitude + (double)OsmMercator.falseEasting(aZoomlevel));
        x = Math.min(x, OsmMercator.getMaxPixels(aZoomlevel) - 1);
        return x;
    }

    public static int LatToY(double aLat, int aZoomlevel) {
        if (aLat < -85.05112877980659) {
            aLat = -85.05112877980659;
        } else if (aLat > 85.05112877980659) {
            aLat = 85.05112877980659;
        }
        double latitude = Math.toRadians(aLat);
        int y = (int)(-1.0 * (OsmMercator.radius(aZoomlevel) / 2.0 * Math.log((1.0 + Math.sin(latitude)) / (1.0 - Math.sin(latitude)))) - (double)OsmMercator.falseNorthing(aZoomlevel));
        y = Math.min(y, OsmMercator.getMaxPixels(aZoomlevel) - 1);
        return y;
    }

    public static double XToLon(int aX, int aZoomlevel) {
        double longRadians = (double)(aX -= OsmMercator.falseEasting(aZoomlevel)) / OsmMercator.radius(aZoomlevel);
        double longDegrees = Math.toDegrees(longRadians);
        return longDegrees;
    }

    public static double YToLat(int aY, int aZoomlevel) {
        double latitude = 1.5707963267948966 - 2.0 * Math.atan(Math.exp(-1.0 * (double)(aY += OsmMercator.falseNorthing(aZoomlevel)) / OsmMercator.radius(aZoomlevel)));
        return -1.0 * Math.toDegrees(latitude);
    }
}

