/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.prefabvalues.factories;

import java.util.LinkedHashSet;
import nl.jqno.equalsverifier.internal.prefabvalues.PrefabValues;
import nl.jqno.equalsverifier.internal.prefabvalues.Tuple;
import nl.jqno.equalsverifier.internal.prefabvalues.TypeTag;
import nl.jqno.equalsverifier.internal.prefabvalues.factories.AbstractReflectiveGenericFactory;
import nl.jqno.equalsverifier.internal.reflection.ConditionalInstantiator;
import nl.jqno.equalsverifier.internal.reflection.Util;

public abstract class ReflectiveCollectionFactory<T>
extends AbstractReflectiveGenericFactory<T> {
    private final String typeName;

    ReflectiveCollectionFactory(String typeName) {
        this.typeName = typeName;
    }

    public static <T> ReflectiveCollectionFactory<T> callFactoryMethod(final String typeName, final String methodName) {
        return new ReflectiveCollectionFactory<T>(typeName){

            @Override
            protected Object createEmpty() {
                return new ConditionalInstantiator(typeName).callFactory(methodName, Util.classes(new Class[0]), Util.objects(new Object[0]));
            }
        };
    }

    public static <T> ReflectiveCollectionFactory<T> callFactoryMethodWithParameter(final String typeName, final String methodName, final Class<?> parameterType, final Object parameterValue) {
        return new ReflectiveCollectionFactory<T>(typeName){

            @Override
            protected Object createEmpty() {
                return new ConditionalInstantiator(typeName).callFactory(methodName, Util.classes(parameterType), Util.objects(parameterValue));
            }
        };
    }

    protected String getTypeName() {
        return this.typeName;
    }

    protected abstract Object createEmpty();

    @Override
    public Tuple<T> createValues(TypeTag tag, PrefabValues prefabValues, LinkedHashSet<TypeTag> typeStack) {
        LinkedHashSet<TypeTag> clone = this.cloneWith(typeStack, tag);
        TypeTag entryTag = this.determineAndCacheActualTypeTag(0, tag, prefabValues, clone);
        Object red = this.createWith(prefabValues.giveRed(entryTag));
        Object black = this.createWith(prefabValues.giveBlack(entryTag));
        return Tuple.of(red, black);
    }

    private Object createWith(Object value) {
        Object result = this.createEmpty();
        this.invoke(Util.classForName(this.typeName), result, "add", Util.classes(Object.class), Util.objects(value));
        return result;
    }
}

