/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.constant;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.method.MethodDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.type.TypeDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.Implementation;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.Duplication;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.StackManipulation;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.TypeCreation;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.constant.NullConstant;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.constant.TextConstant;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.member.MethodInvocation;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.MethodVisitor;

public class SerializedConstant
implements StackManipulation {
    private static final String CHARSET = "ISO-8859-1";
    private final String serialization;

    protected SerializedConstant(String serialization) {
        this.serialization = serialization;
    }

    public static StackManipulation of(Serializable value) {
        if (value == null) {
            return NullConstant.INSTANCE;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            try {
                objectOutputStream.writeObject(value);
            }
            finally {
                objectOutputStream.close();
            }
            return new SerializedConstant(byteArrayOutputStream.toString(CHARSET));
        }
        catch (IOException exception) {
            throw new IllegalStateException("Cannot serialize " + value, exception);
        }
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
        try {
            return new StackManipulation.Compound(TypeCreation.of(new TypeDescription.ForLoadedType(ObjectInputStream.class)), Duplication.SINGLE, TypeCreation.of(new TypeDescription.ForLoadedType(ByteArrayInputStream.class)), Duplication.SINGLE, new TextConstant(this.serialization), new TextConstant(CHARSET), MethodInvocation.invoke(new MethodDescription.ForLoadedMethod(String.class.getMethod("getBytes", String.class))), MethodInvocation.invoke(new MethodDescription.ForLoadedConstructor(ByteArrayInputStream.class.getConstructor(byte[].class))), MethodInvocation.invoke(new MethodDescription.ForLoadedConstructor(ObjectInputStream.class.getConstructor(InputStream.class))), MethodInvocation.invoke(new MethodDescription.ForLoadedMethod(ObjectInputStream.class.getMethod("readObject", new Class[0])))).apply(methodVisitor, implementationContext);
        }
        catch (NoSuchMethodException exception) {
            throw new IllegalStateException("Could not locate Java API method", exception);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SerializedConstant)) {
            return false;
        }
        SerializedConstant other = (SerializedConstant)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$serialization = this.serialization;
        String other$serialization = other.serialization;
        return !(this$serialization == null ? other$serialization != null : !this$serialization.equals(other$serialization));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SerializedConstant;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $serialization = this.serialization;
        result = result * 59 + ($serialization == null ? 43 : $serialization.hashCode());
        return result;
    }
}

