/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.method.MethodDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.type.TypeDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.type.TypeList;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.dynamic.scaffold.InstrumentedType;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.Implementation;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.ByteCodeAppender;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.StackManipulation;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.member.MethodReturn;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.MethodVisitor;

public class DefaultMethodCall
implements Implementation {
    private final List<TypeDescription> prioritizedInterfaces;

    protected DefaultMethodCall(List<TypeDescription> prioritizedInterfaces) {
        this.prioritizedInterfaces = prioritizedInterfaces;
    }

    public static Implementation prioritize(Class<?> ... prioritizedInterface) {
        return DefaultMethodCall.prioritize(new TypeList.ForLoadedTypes(prioritizedInterface));
    }

    public static Implementation prioritize(Iterable<? extends Class<?>> prioritizedInterfaces) {
        ArrayList list = new ArrayList();
        for (Class<?> prioritizedInterface : prioritizedInterfaces) {
            list.add(prioritizedInterface);
        }
        return DefaultMethodCall.prioritize(new TypeList.ForLoadedTypes(list));
    }

    public static Implementation prioritize(TypeDescription ... prioritizedInterface) {
        return DefaultMethodCall.prioritize(Arrays.asList(prioritizedInterface));
    }

    public static Implementation prioritize(Collection<? extends TypeDescription> prioritizedInterfaces) {
        return new DefaultMethodCall(new ArrayList<TypeDescription>(prioritizedInterfaces));
    }

    public static Implementation unambiguousOnly() {
        return new DefaultMethodCall(Collections.<TypeDescription>emptyList());
    }

    @Override
    public InstrumentedType prepare(InstrumentedType instrumentedType) {
        return instrumentedType;
    }

    @Override
    public ByteCodeAppender appender(Implementation.Target implementationTarget) {
        return new Appender(implementationTarget, this.filterRelevant(implementationTarget.getInstrumentedType()));
    }

    private List<TypeDescription> filterRelevant(TypeDescription typeDescription) {
        ArrayList<TypeDescription> filtered = new ArrayList<TypeDescription>(this.prioritizedInterfaces.size());
        HashSet<TypeDescription> relevant = new HashSet<TypeDescription>(typeDescription.getInterfaces().asErasures());
        for (TypeDescription prioritizedInterface : this.prioritizedInterfaces) {
            if (!relevant.remove(prioritizedInterface)) continue;
            filtered.add(prioritizedInterface);
        }
        return filtered;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultMethodCall)) {
            return false;
        }
        DefaultMethodCall other = (DefaultMethodCall)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<TypeDescription> this$prioritizedInterfaces = this.prioritizedInterfaces;
        List<TypeDescription> other$prioritizedInterfaces = other.prioritizedInterfaces;
        return !(this$prioritizedInterfaces == null ? other$prioritizedInterfaces != null : !((Object)this$prioritizedInterfaces).equals(other$prioritizedInterfaces));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DefaultMethodCall;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<TypeDescription> $prioritizedInterfaces = this.prioritizedInterfaces;
        result = result * 59 + ($prioritizedInterfaces == null ? 43 : ((Object)$prioritizedInterfaces).hashCode());
        return result;
    }

    protected static class Appender
    implements ByteCodeAppender {
        private final Implementation.Target implementationTarget;
        private final List<TypeDescription> prioritizedInterfaces;
        private final Set<TypeDescription> nonPrioritizedInterfaces;

        protected Appender(Implementation.Target implementationTarget, List<TypeDescription> prioritizedInterfaces) {
            this.implementationTarget = implementationTarget;
            this.prioritizedInterfaces = prioritizedInterfaces;
            this.nonPrioritizedInterfaces = new HashSet<TypeDescription>(implementationTarget.getInstrumentedType().getInterfaces().asErasures());
            this.nonPrioritizedInterfaces.removeAll(prioritizedInterfaces);
        }

        @Override
        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
            StackManipulation defaultMethodInvocation = this.locateDefault(instrumentedMethod);
            if (!defaultMethodInvocation.isValid()) {
                throw new IllegalStateException("Cannot invoke default method on " + instrumentedMethod);
            }
            StackManipulation.Size stackSize = new StackManipulation.Compound(MethodVariableAccess.allArgumentsOf(instrumentedMethod).prependThisReference(), defaultMethodInvocation, MethodReturn.of(instrumentedMethod.getReturnType())).apply(methodVisitor, implementationContext);
            return new ByteCodeAppender.Size(stackSize.getMaximalSize(), instrumentedMethod.getStackSize());
        }

        private StackManipulation locateDefault(MethodDescription methodDescription) {
            MethodDescription.SignatureToken methodToken = methodDescription.asSignatureToken();
            Implementation.SpecialMethodInvocation specialMethodInvocation = Implementation.SpecialMethodInvocation.Illegal.INSTANCE;
            for (TypeDescription typeDescription : this.prioritizedInterfaces) {
                specialMethodInvocation = this.implementationTarget.invokeDefault(methodToken, typeDescription);
                if (!specialMethodInvocation.isValid()) continue;
                return specialMethodInvocation;
            }
            for (TypeDescription typeDescription : this.nonPrioritizedInterfaces) {
                Implementation.SpecialMethodInvocation other = this.implementationTarget.invokeDefault(methodToken, typeDescription);
                if (specialMethodInvocation.isValid() && other.isValid()) {
                    throw new IllegalStateException(methodDescription + " has an ambiguous default method with " + other.getMethodDescription() + " and " + specialMethodInvocation.getMethodDescription());
                }
                specialMethodInvocation = other;
            }
            return specialMethodInvocation;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Appender)) {
                return false;
            }
            Appender other = (Appender)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Implementation.Target this$implementationTarget = this.implementationTarget;
            Implementation.Target other$implementationTarget = other.implementationTarget;
            if (this$implementationTarget == null ? other$implementationTarget != null : !this$implementationTarget.equals(other$implementationTarget)) {
                return false;
            }
            List<TypeDescription> this$prioritizedInterfaces = this.prioritizedInterfaces;
            List<TypeDescription> other$prioritizedInterfaces = other.prioritizedInterfaces;
            return !(this$prioritizedInterfaces == null ? other$prioritizedInterfaces != null : !((Object)this$prioritizedInterfaces).equals(other$prioritizedInterfaces));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Appender;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Implementation.Target $implementationTarget = this.implementationTarget;
            result = result * 59 + ($implementationTarget == null ? 43 : $implementationTarget.hashCode());
            List<TypeDescription> $prioritizedInterfaces = this.prioritizedInterfaces;
            result = result * 59 + ($prioritizedInterfaces == null ? 43 : ((Object)$prioritizedInterfaces).hashCode());
            return result;
        }
    }
}

