/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.checkers;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Field;
import nl.jqno.equalsverifier.Warning;
import nl.jqno.equalsverifier.internal.checkers.Checker;
import nl.jqno.equalsverifier.internal.reflection.ClassAccessor;
import nl.jqno.equalsverifier.internal.reflection.FieldAccessor;
import nl.jqno.equalsverifier.internal.reflection.annotations.NonnullAnnotationVerifier;
import nl.jqno.equalsverifier.internal.util.Assert;
import nl.jqno.equalsverifier.internal.util.Configuration;
import nl.jqno.equalsverifier.internal.util.FieldInspector;
import nl.jqno.equalsverifier.internal.util.Formatter;

public class NullChecker<T>
implements Checker {
    private final Configuration<T> config;
    private final ClassAccessor<T> classAccessor;

    public NullChecker(Configuration<T> config) {
        this.config = config;
        this.classAccessor = config.createClassAccessor();
    }

    @Override
    public void check() {
        if (this.config.getWarningsToSuppress().contains((Object)Warning.NULL_FIELDS)) {
            return;
        }
        FieldInspector<T> inspector = new FieldInspector<T>(this.classAccessor, this.config.getTypeTag());
        inspector.check(new NullPointerExceptionFieldCheck());
    }

    private class NullPointerExceptionFieldCheck
    implements FieldInspector.FieldCheck {
        private NullPointerExceptionFieldCheck() {
        }

        @Override
        public void execute(FieldAccessor referenceAccessor, FieldAccessor changedAccessor) {
            Field field = referenceAccessor.getField();
            if (NullChecker.this.config.getNonnullFields().contains(field.getName())) {
                return;
            }
            if (field.getType().isPrimitive()) {
                return;
            }
            if (NonnullAnnotationVerifier.fieldIsNonnull(NullChecker.this.classAccessor, field)) {
                return;
            }
            if (referenceAccessor.fieldIsStatic()) {
                Object saved = referenceAccessor.get();
                referenceAccessor.defaultStaticField();
                this.performTests(field, referenceAccessor.getObject(), changedAccessor.getObject());
                referenceAccessor.set(saved);
            } else {
                changedAccessor.defaultField();
                this.performTests(field, referenceAccessor.getObject(), changedAccessor.getObject());
                referenceAccessor.defaultField();
            }
        }

        private void performTests(Field field, final Object reference, final Object changed) {
            this.handle("equals", field, new Runnable(){

                @Override
                @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED"}, justification="We only want to see if it throws an exception.")
                public void run() {
                    reference.equals(changed);
                }
            });
            this.handle("equals", field, new Runnable(){

                @Override
                @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED"}, justification="We only want to see if it throws an exception.")
                public void run() {
                    changed.equals(reference);
                }
            });
            this.handle("hashCode", field, new Runnable(){

                @Override
                public void run() {
                    NullChecker.this.config.getCachedHashCodeInitializer().getInitializedHashCode(changed);
                }
            });
        }

        private void handle(String testedMethodName, Field field, Runnable r) {
            try {
                r.run();
            }
            catch (NullPointerException e) {
                this.npeThrown(testedMethodName, field, e);
            }
            catch (Exception e) {
                this.exceptionThrown(testedMethodName, field, e);
            }
        }

        private void npeThrown(String method, Field field, Exception e) {
            Assert.fail(Formatter.of("Non-nullity: %% throws NullPointerException on field %%.", method, field.getName()), e);
        }

        private void exceptionThrown(String method, Field field, Exception e) {
            Assert.fail(Formatter.of("%% throws %% when field %% is null.", method, e.getClass().getSimpleName(), field.getName()), e);
        }
    }
}

