/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import nl.jqno.equalsverifier.Warning;
import nl.jqno.equalsverifier.internal.checkers.AbstractDelegationChecker;
import nl.jqno.equalsverifier.internal.checkers.CachedHashCodeChecker;
import nl.jqno.equalsverifier.internal.checkers.Checker;
import nl.jqno.equalsverifier.internal.checkers.ExamplesChecker;
import nl.jqno.equalsverifier.internal.checkers.FieldsChecker;
import nl.jqno.equalsverifier.internal.checkers.HierarchyChecker;
import nl.jqno.equalsverifier.internal.checkers.NullChecker;
import nl.jqno.equalsverifier.internal.checkers.SignatureChecker;
import nl.jqno.equalsverifier.internal.exceptions.MessagingException;
import nl.jqno.equalsverifier.internal.lib.asm.Type;
import nl.jqno.equalsverifier.internal.prefabvalues.JavaApiPrefabValues;
import nl.jqno.equalsverifier.internal.prefabvalues.TypeTag;
import nl.jqno.equalsverifier.internal.reflection.ClassAccessor;
import nl.jqno.equalsverifier.internal.reflection.FieldIterable;
import nl.jqno.equalsverifier.internal.util.CachedHashCodeInitializer;
import nl.jqno.equalsverifier.internal.util.Configuration;
import nl.jqno.equalsverifier.internal.util.Formatter;

public final class EqualsVerifier<T> {
    private Configuration<T> config;

    private EqualsVerifier(Configuration<T> config) {
        this.config = config;
        JavaApiPrefabValues.addTo(config.getPrefabValues());
    }

    public static <T> EqualsVerifier<T> forClass(Class<T> type) {
        Configuration<T> config = Configuration.of(type);
        return new EqualsVerifier<T>(config);
    }

    @SafeVarargs
    public static <T> RelaxedEqualsVerifierHelper<T> forRelaxedEqualExamples(T first, T second, T ... more) {
        List<T> examples = EqualsVerifier.buildListOfAtLeastTwo(first, second, more);
        Class<?> type = first.getClass();
        return new RelaxedEqualsVerifierHelper(type, examples);
    }

    public EqualsVerifier<T> suppress(Warning ... warnings) {
        EnumSet<Warning> ws = this.config.getWarningsToSuppress();
        Collections.addAll(ws, warnings);
        this.config = this.config.withWarningsToSuppress(ws);
        this.checkNonnullFields();
        return this;
    }

    public <S> EqualsVerifier<T> withPrefabValues(Class<S> otherType, S red, S black) {
        if (otherType == null) {
            throw new NullPointerException("Type is null");
        }
        if (red == null || black == null) {
            throw new NullPointerException("One or both values are null.");
        }
        if (red.equals(black)) {
            throw new IllegalArgumentException("Both values are equal.");
        }
        this.config.getPrefabValues().addFactory(otherType, red, black);
        return this;
    }

    public EqualsVerifier<T> usingGetClass() {
        this.config = this.config.withUsingGetClass();
        return this;
    }

    public EqualsVerifier<T> withIgnoredFields(String ... fields) {
        this.checkIgnoredFields();
        List<String> ignoredFields = Arrays.asList(fields);
        this.validateFieldNamesExist(ignoredFields);
        this.config = this.config.withIgnoredFields(ignoredFields);
        return this;
    }

    public EqualsVerifier<T> withOnlyTheseFields(String ... fields) {
        this.checkIgnoredFields();
        ArrayList<String> ignoredFields = new ArrayList<String>();
        HashSet<String> specifiedFields = new HashSet<String>(Arrays.asList(fields));
        HashSet<String> actualFieldNames = new HashSet<String>();
        for (Field f : FieldIterable.of(this.config.getType())) {
            String name = f.getName();
            actualFieldNames.add(name);
            if (specifiedFields.contains(name)) continue;
            ignoredFields.add(name);
        }
        for (String field : specifiedFields) {
            if (actualFieldNames.contains(field)) continue;
            throw new IllegalArgumentException("Class " + this.config.getType().getSimpleName() + " does not contain field " + field + ".");
        }
        this.config = this.config.withIgnoredFields(ignoredFields);
        return this;
    }

    public EqualsVerifier<T> withNonnullFields(String ... fields) {
        List<String> nonnullFields = Arrays.asList(fields);
        this.validateFieldNamesExist(nonnullFields);
        this.config = this.config.withNonnullFields(nonnullFields);
        this.checkNonnullFields();
        return this;
    }

    public EqualsVerifier<T> withIgnoredAnnotations(Class<?> ... annotations) {
        this.validateAnnotationsAreValid(annotations);
        ArrayList<String> ignoredAnnotationDescriptors = new ArrayList<String>();
        for (Class<?> ignoredAnnotation : annotations) {
            ignoredAnnotationDescriptors.add(Type.getDescriptor(ignoredAnnotation));
        }
        this.config = this.config.withIgnoredAnnotations(ignoredAnnotationDescriptors);
        return this;
    }

    public EqualsVerifier<T> withRedefinedSuperclass() {
        this.config = this.config.withRedefinedSuperclass();
        return this;
    }

    public EqualsVerifier<T> withRedefinedSubclass(Class<? extends T> redefinedSubclass) {
        this.config = this.config.withRedefinedSubclass(redefinedSubclass);
        return this;
    }

    public EqualsVerifier<T> withCachedHashCode(String cachedHashCodeField, String calculateHashCodeMethod, T example) {
        CachedHashCodeInitializer<T> cachedHashCodeInitializer = new CachedHashCodeInitializer<T>(this.config.getType(), cachedHashCodeField, calculateHashCodeMethod, example);
        this.config = this.config.withCachedHashCodeInitializer(cachedHashCodeInitializer);
        return this;
    }

    private void checkNonnullFields() {
        if (!this.config.getNonnullFields().isEmpty() && this.config.getWarningsToSuppress().contains((Object)Warning.NULL_FIELDS)) {
            throw new IllegalArgumentException("You can call either withNonnullFields or suppress Warning.NULL_FIELDS, but not both.");
        }
    }

    private void checkIgnoredFields() {
        if (!this.config.getIgnoredFields().isEmpty()) {
            throw new IllegalArgumentException("You can call either withOnlyTheseFields or withIgnoredFields, but not both.");
        }
    }

    private void validateFieldNamesExist(List<String> givenFields) {
        HashSet<String> actualFieldNames = new HashSet<String>();
        for (Field field : FieldIterable.of(this.config.getType())) {
            actualFieldNames.add(field.getName());
        }
        for (String string : givenFields) {
            if (actualFieldNames.contains(string)) continue;
            throw new IllegalArgumentException("Class " + this.config.getType().getSimpleName() + " does not contain field " + string + ".");
        }
    }

    private void validateAnnotationsAreValid(Class<?> ... givenAnnotations) {
        for (Class<?> annotation : givenAnnotations) {
            if (annotation.isAnnotation()) continue;
            throw new IllegalArgumentException("Class " + annotation.getCanonicalName() + " is not an annotation.");
        }
    }

    public void verify() {
        try {
            this.performVerification();
        }
        catch (MessagingException e) {
            this.handleError(e, e.getCause());
        }
        catch (Throwable e) {
            this.handleError(e, e);
        }
    }

    private void handleError(Throwable messageContainer, Throwable trueCause) {
        boolean showCauseExceptionInMessage = trueCause != null && trueCause.equals(messageContainer);
        Formatter message = Formatter.of("%%%%\nFor more information, go to: http://www.jqno.nl/equalsverifier/errormessages", showCauseExceptionInMessage ? trueCause.getClass().getSimpleName() + ": " : "", messageContainer.getMessage() == null ? "" : messageContainer.getMessage());
        AssertionError error = new AssertionError((Object)message.format());
        ((Throwable)((Object)error)).initCause(trueCause);
        throw error;
    }

    private void performVerification() {
        if (this.config.getType().isEnum()) {
            return;
        }
        this.verifyWithoutExamples();
        this.ensureUnequalExamples();
        this.verifyWithExamples();
    }

    private void verifyWithoutExamples() {
        Checker[] checkers;
        for (Checker checker : checkers = new Checker[]{new SignatureChecker<T>(this.config), new AbstractDelegationChecker<T>(this.config), new NullChecker<T>(this.config), new CachedHashCodeChecker<T>(this.config)}) {
            checker.check();
        }
    }

    private void ensureUnequalExamples() {
        if (this.config.getUnequalExamples().size() > 0) {
            return;
        }
        TypeTag tag = this.config.getTypeTag();
        ClassAccessor<T> classAccessor = this.config.createClassAccessor();
        ArrayList<T> unequalExamples = new ArrayList<T>();
        unequalExamples.add(classAccessor.getRedObject(tag));
        unequalExamples.add(classAccessor.getBlackObject(tag));
        this.config = this.config.withUnequalExamples(unequalExamples);
    }

    private void verifyWithExamples() {
        Checker[] checkers;
        for (Checker checker : checkers = new Checker[]{new ExamplesChecker<T>(this.config), new HierarchyChecker<T>(this.config), new FieldsChecker<T>(this.config)}) {
            checker.check();
        }
    }

    @SafeVarargs
    private static <T> List<T> buildListOfAtLeastOne(T first, T ... more) {
        if (first == null) {
            throw new IllegalArgumentException("First example is null.");
        }
        ArrayList<T> result = new ArrayList<T>();
        result.add(first);
        EqualsVerifier.addArrayElementsToList(result, more);
        return result;
    }

    @SafeVarargs
    private static <T> List<T> buildListOfAtLeastTwo(T first, T second, T ... more) {
        if (first == null) {
            throw new IllegalArgumentException("First example is null.");
        }
        if (second == null) {
            throw new IllegalArgumentException("Second example is null.");
        }
        ArrayList<T> result = new ArrayList<T>();
        result.add(first);
        result.add(second);
        EqualsVerifier.addArrayElementsToList(result, more);
        return result;
    }

    @SafeVarargs
    private static <T> void addArrayElementsToList(List<T> list, T ... more) {
        if (more != null) {
            for (T e : more) {
                if (e == null) {
                    throw new IllegalArgumentException("One of the examples is null.");
                }
                list.add(e);
            }
        }
    }

    private static <T> boolean listContainsDuplicates(List<T> list) {
        return list.size() != new HashSet<T>(list).size();
    }

    public static final class RelaxedEqualsVerifierHelper<T> {
        private final Class<T> type;
        private final List<T> equalExamples;

        private RelaxedEqualsVerifierHelper(Class<T> type, List<T> examples) {
            this.type = type;
            this.equalExamples = examples;
        }

        public EqualsVerifier<T> andUnequalExample(T example) {
            return this.andUnequalExamples(example, new Object[0]);
        }

        @SafeVarargs
        public final EqualsVerifier<T> andUnequalExamples(T first, T ... more) {
            List unequalExamples = EqualsVerifier.buildListOfAtLeastOne(first, more);
            if (EqualsVerifier.listContainsDuplicates(unequalExamples)) {
                throw new IllegalArgumentException("Two objects are equal to each other.");
            }
            for (Object example : unequalExamples) {
                if (!this.equalExamples.contains(example)) continue;
                throw new IllegalArgumentException("An equal example also appears as unequal example.");
            }
            Configuration<T> config = Configuration.of(this.type).withEqualExamples(this.equalExamples).withUnequalExamples(unequalExamples);
            return new EqualsVerifier(config).suppress(Warning.ALL_FIELDS_SHOULD_BE_USED);
        }
    }
}

