/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.osb.i18n;

import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class Messages {
    private ResourceBundle bundle;
    private static Messages instance;

    private Messages() {
        try {
            this.loadBundle(Locale.getDefault());
        }
        catch (Exception e) {
            System.err.println("Couldn't load resource bundle for locale " + Locale.getDefault());
            try {
                this.loadBundle(Locale.ENGLISH);
            }
            catch (Exception e1) {
                System.err.println("Couldn't load default resource bundle");
                e.printStackTrace();
            }
        }
    }

    public static ResourceBundle getBundle() {
        if (instance == null) {
            instance = new Messages();
        }
        return instance.getResourceBundle();
    }

    public static String translate(Class clazz, String key) {
        key = clazz.getName() + "." + key;
        return Messages.getBundle().getString(key);
    }

    private void loadBundle(Locale locale) throws Exception {
        System.out.println("Trying to load locale " + locale.getLanguage() + " for openstreetbugs");
        InputStream in = Messages.class.getResourceAsStream("language_" + locale.getLanguage() + ".properties");
        this.bundle = new PropertyResourceBundle(in);
    }

    private ResourceBundle getResourceBundle() {
        return this.bundle;
    }

    public static String translate(Class clazz, String key, Object[] params) {
        String mesg = Messages.translate(clazz, key);
        MessageFormat format = new MessageFormat("");
        format.applyPattern(mesg);
        return format.format(params);
    }
}

