/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.reflection.annotations;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import nl.jqno.equalsverifier.internal.lib.asm.Type;
import nl.jqno.equalsverifier.internal.reflection.Util;
import nl.jqno.equalsverifier.internal.reflection.annotations.Annotation;
import nl.jqno.equalsverifier.internal.reflection.annotations.AnnotationAccessor;
import nl.jqno.equalsverifier.internal.reflection.annotations.AnnotationProperties;

public enum SupportedAnnotations implements Annotation
{
    IMMUTABLE(false, "Immutable"),
    NONNULL(true, "Nonnull", "NonNull", "NotNull"),
    ENTITY(false, "javax.persistence.Entity", "javax.persistence.Embeddable", "javax.persistence.MappedSuperclass"),
    TRANSIENT(true, "javax.persistence.Transient"),
    FINDBUGS1X_DEFAULT_ANNOTATION_NONNULL(false, new String[]{"edu.umd.cs.findbugs.annotations.DefaultAnnotation", "edu.umd.cs.findbugs.annotations.DefaultAnnotationForFields"}){

        @Override
        public boolean validate(AnnotationProperties properties, Set<String> ignoredAnnotations) {
            Set<Object> values = properties.getArrayValues("value");
            for (Object value : values) {
                for (String descriptor : NONNULL.descriptors()) {
                    Type type = (Type)value;
                    String typeDescriptor = type.getDescriptor();
                    if (!typeDescriptor.contains(descriptor) || ignoredAnnotations.contains(typeDescriptor)) continue;
                    return true;
                }
            }
            return false;
        }
    }
    ,
    JSR305_DEFAULT_ANNOTATION_NONNULL(false, new String[]{""}){

        @Override
        public boolean validate(AnnotationProperties properties, Set<String> ignoredAnnotations) {
            try {
                Type t = Type.getType(properties.getDescriptor());
                Class<?> type = Util.classForName(t.getClassName());
                if (type == null) {
                    return false;
                }
                AnnotationAccessor accessor = new AnnotationAccessor(new Annotation[]{NONNULL, JSR305_TYPE_QUALIFIER_DEFAULT}, type, ignoredAnnotations, false);
                boolean hasNonnullAnnotation = accessor.typeHas(NONNULL);
                boolean hasValidTypeQualifierDefault = accessor.typeHas(JSR305_TYPE_QUALIFIER_DEFAULT);
                return hasNonnullAnnotation && hasValidTypeQualifierDefault;
            }
            catch (UnsupportedClassVersionError ignored) {
                return false;
            }
        }
    }
    ,
    JSR305_TYPE_QUALIFIER_DEFAULT(false, new String[]{"javax.annotation.meta.TypeQualifierDefault"}){

        @Override
        public boolean validate(AnnotationProperties properties, Set<String> ignoredAnnotations) {
            return properties.getArrayValues("value").contains("FIELD");
        }
    }
    ,
    ECLIPSE_DEFAULT_ANNOTATION_NONNULL(false, new String[]{"org.eclipse.jdt.annotation.NonNullByDefault"}){

        @Override
        public boolean validate(AnnotationProperties properties, Set<String> ignoredAnnotations) {
            Set<Object> values = properties.getArrayValues("value");
            if (values == null) {
                return true;
            }
            for (Object value : values) {
                if (!"FIELD".equals(value)) continue;
                return true;
            }
            return false;
        }
    }
    ,
    NULLABLE(false, "Nullable", "CheckForNull");

    private final boolean inherits;
    private final List<String> descriptors;

    private SupportedAnnotations(boolean inherits, String ... descriptors) {
        this.inherits = inherits;
        this.descriptors = Arrays.asList(descriptors);
    }

    @Override
    public Iterable<String> descriptors() {
        return this.descriptors;
    }

    @Override
    public boolean inherits() {
        return this.inherits;
    }

    @Override
    public boolean validate(AnnotationProperties properties, Set<String> ignoredAnnotations) {
        return true;
    }
}

