/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation;

import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.field.FieldDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.field.FieldList;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.method.MethodDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.method.ParameterDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.type.TypeDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.dynamic.scaffold.InstrumentedType;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.Implementation;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.LoadedTypeInitializer;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.ByteCodeAppender;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.StackManipulation;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.assign.Assigner;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.constant.ClassConstant;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.constant.DoubleConstant;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.constant.FloatConstant;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.constant.IntegerConstant;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.constant.JavaConstantValue;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.constant.LongConstant;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.constant.NullConstant;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.constant.TextConstant;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.member.FieldAccess;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.member.MethodReturn;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.jar.asm.MethodVisitor;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.matcher.ElementMatchers;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.utility.JavaConstant;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.utility.JavaType;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.utility.RandomString;

public abstract class FixedValue
implements Implementation {
    protected final Assigner assigner;
    protected final Assigner.Typing typing;

    protected FixedValue(Assigner assigner, Assigner.Typing typing) {
        this.assigner = assigner;
        this.typing = typing;
    }

    public static AssignerConfigurable value(Object fixedValue) {
        Class<?> type = fixedValue.getClass();
        if (type == String.class) {
            return new ForPoolValue((StackManipulation)new TextConstant((String)fixedValue), TypeDescription.STRING);
        }
        if (type == Class.class) {
            return new ForPoolValue(ClassConstant.of(new TypeDescription.ForLoadedType((Class)fixedValue)), TypeDescription.CLASS);
        }
        if (type == Boolean.class) {
            return new ForPoolValue(IntegerConstant.forValue((Boolean)fixedValue), Boolean.TYPE);
        }
        if (type == Byte.class) {
            return new ForPoolValue(IntegerConstant.forValue(((Byte)fixedValue).byteValue()), Byte.TYPE);
        }
        if (type == Short.class) {
            return new ForPoolValue(IntegerConstant.forValue(((Short)fixedValue).shortValue()), Short.TYPE);
        }
        if (type == Character.class) {
            return new ForPoolValue(IntegerConstant.forValue(((Character)fixedValue).charValue()), Character.TYPE);
        }
        if (type == Integer.class) {
            return new ForPoolValue(IntegerConstant.forValue((Integer)fixedValue), Integer.TYPE);
        }
        if (type == Long.class) {
            return new ForPoolValue(LongConstant.forValue((Long)fixedValue), Long.TYPE);
        }
        if (type == Float.class) {
            return new ForPoolValue(FloatConstant.forValue(((Float)fixedValue).floatValue()), Float.TYPE);
        }
        if (type == Double.class) {
            return new ForPoolValue(DoubleConstant.forValue((Double)fixedValue), Double.TYPE);
        }
        if (JavaType.METHOD_HANDLE.getTypeStub().isAssignableFrom(type)) {
            return new ForPoolValue((StackManipulation)new JavaConstantValue(JavaConstant.MethodHandle.ofLoaded(fixedValue)), type);
        }
        if (JavaType.METHOD_TYPE.getTypeStub().represents(type)) {
            return new ForPoolValue((StackManipulation)new JavaConstantValue(JavaConstant.MethodType.ofLoaded(fixedValue)), type);
        }
        return FixedValue.reference(fixedValue);
    }

    public static AssignerConfigurable reference(Object fixedValue) {
        return new ForValue(fixedValue);
    }

    public static AssignerConfigurable reference(Object fixedValue, String fieldName) {
        return new ForValue(fieldName, fixedValue);
    }

    public static AssignerConfigurable value(TypeDescription fixedValue) {
        return new ForPoolValue(ClassConstant.of(fixedValue), TypeDescription.CLASS);
    }

    public static AssignerConfigurable value(JavaConstant fixedValue) {
        return new ForPoolValue(fixedValue.asStackManipulation(), fixedValue.getType());
    }

    public static AssignerConfigurable argument(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Argument index cannot be negative: " + index);
        }
        return new ForArgument(index);
    }

    public static AssignerConfigurable self() {
        return new ForThisValue();
    }

    public static Implementation nullValue() {
        return ForNullValue.INSTANCE;
    }

    public static AssignerConfigurable originType() {
        return new ForOriginType();
    }

    protected ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod, TypeDescription.Generic fixedValueType, StackManipulation valueLoadingInstruction) {
        StackManipulation assignment = this.assigner.assign(fixedValueType, instrumentedMethod.getReturnType(), this.typing);
        if (!assignment.isValid()) {
            throw new IllegalArgumentException("Cannot return value of type " + fixedValueType + " for " + instrumentedMethod);
        }
        StackManipulation.Size stackSize = new StackManipulation.Compound(valueLoadingInstruction, assignment, MethodReturn.of(instrumentedMethod.getReturnType())).apply(methodVisitor, implementationContext);
        return new ByteCodeAppender.Size(stackSize.getMaximalSize(), instrumentedMethod.getStackSize());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FixedValue)) {
            return false;
        }
        FixedValue other = (FixedValue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Assigner this$assigner = this.assigner;
        Assigner other$assigner = other.assigner;
        if (this$assigner == null ? other$assigner != null : !this$assigner.equals(other$assigner)) {
            return false;
        }
        Assigner.Typing this$typing = this.typing;
        Assigner.Typing other$typing = other.typing;
        return !(this$typing == null ? other$typing != null : !((Object)((Object)this$typing)).equals((Object)other$typing));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FixedValue;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Assigner $assigner = this.assigner;
        result = result * 59 + ($assigner == null ? 43 : $assigner.hashCode());
        Assigner.Typing $typing = this.typing;
        result = result * 59 + ($typing == null ? 43 : ((Object)((Object)$typing)).hashCode());
        return result;
    }

    protected static class ForValue
    extends FixedValue
    implements AssignerConfigurable {
        private static final String PREFIX = "value";
        private final String fieldName;
        private final Object value;
        private final TypeDescription.Generic fieldType;

        protected ForValue(Object value) {
            this(String.format("%s$%s", PREFIX, RandomString.hashOf(value.hashCode())), value);
        }

        protected ForValue(String fieldName, Object value) {
            this(Assigner.DEFAULT, Assigner.Typing.STATIC, fieldName, value);
        }

        private ForValue(Assigner assigner, Assigner.Typing typing, String fieldName, Object value) {
            super(assigner, typing);
            this.fieldName = fieldName;
            this.value = value;
            this.fieldType = new TypeDescription.Generic.OfNonGenericType.ForLoadedType(value.getClass());
        }

        @Override
        public Implementation withAssigner(Assigner assigner, Assigner.Typing typing) {
            return new ForValue(assigner, typing, this.fieldName, this.value);
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType.withField(new FieldDescription.Token(this.fieldName, 4105, this.fieldType)).withInitializer(new LoadedTypeInitializer.ForStaticField(this.fieldName, this.value));
        }

        @Override
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return new StaticFieldByteCodeAppender(implementationTarget.getInstrumentedType());
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ForValue)) {
                return false;
            }
            ForValue other = (ForValue)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$fieldName = this.fieldName;
            String other$fieldName = other.fieldName;
            if (this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName)) {
                return false;
            }
            Object this$value = this.value;
            Object other$value = other.value;
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ForValue;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + super.hashCode();
            String $fieldName = this.fieldName;
            result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
            Object $value = this.value;
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        private class StaticFieldByteCodeAppender
        implements ByteCodeAppender {
            private final StackManipulation fieldGetAccess;

            private StaticFieldByteCodeAppender(TypeDescription instrumentedType) {
                this.fieldGetAccess = FieldAccess.forField((FieldDescription.InDefinedShape)((FieldList)instrumentedType.getDeclaredFields().filter(ElementMatchers.named(ForValue.this.fieldName))).getOnly()).read();
            }

            @Override
            public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
                return ForValue.this.apply(methodVisitor, implementationContext, instrumentedMethod, ForValue.this.fieldType, this.fieldGetAccess);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof StaticFieldByteCodeAppender)) {
                    return false;
                }
                StaticFieldByteCodeAppender other = (StaticFieldByteCodeAppender)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                StackManipulation this$fieldGetAccess = this.fieldGetAccess;
                StackManipulation other$fieldGetAccess = other.fieldGetAccess;
                return !(this$fieldGetAccess == null ? other$fieldGetAccess != null : !this$fieldGetAccess.equals(other$fieldGetAccess));
            }

            protected boolean canEqual(Object other) {
                return other instanceof StaticFieldByteCodeAppender;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                StackManipulation $fieldGetAccess = this.fieldGetAccess;
                result = result * 59 + ($fieldGetAccess == null ? 43 : $fieldGetAccess.hashCode());
                return result;
            }
        }
    }

    protected static class ForPoolValue
    extends FixedValue
    implements AssignerConfigurable,
    ByteCodeAppender {
        private final StackManipulation valueLoadInstruction;
        private final TypeDescription loadedType;

        protected ForPoolValue(StackManipulation valueLoadInstruction, Class<?> loadedType) {
            this(valueLoadInstruction, new TypeDescription.ForLoadedType(loadedType));
        }

        protected ForPoolValue(StackManipulation valueLoadInstruction, TypeDescription loadedType) {
            this(Assigner.DEFAULT, Assigner.Typing.STATIC, valueLoadInstruction, loadedType);
        }

        private ForPoolValue(Assigner assigner, Assigner.Typing typing, StackManipulation valueLoadInstruction, TypeDescription loadedType) {
            super(assigner, typing);
            this.valueLoadInstruction = valueLoadInstruction;
            this.loadedType = loadedType;
        }

        @Override
        public Implementation withAssigner(Assigner assigner, Assigner.Typing typing) {
            return new ForPoolValue(assigner, typing, this.valueLoadInstruction, this.loadedType);
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        @Override
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return this;
        }

        @Override
        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
            return this.apply(methodVisitor, implementationContext, instrumentedMethod, this.loadedType.asGenericType(), this.valueLoadInstruction);
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ForPoolValue)) {
                return false;
            }
            ForPoolValue other = (ForPoolValue)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            StackManipulation this$valueLoadInstruction = this.valueLoadInstruction;
            StackManipulation other$valueLoadInstruction = other.valueLoadInstruction;
            if (this$valueLoadInstruction == null ? other$valueLoadInstruction != null : !this$valueLoadInstruction.equals(other$valueLoadInstruction)) {
                return false;
            }
            TypeDescription this$loadedType = this.loadedType;
            TypeDescription other$loadedType = other.loadedType;
            return !(this$loadedType == null ? other$loadedType != null : !this$loadedType.equals(other$loadedType));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ForPoolValue;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + super.hashCode();
            StackManipulation $valueLoadInstruction = this.valueLoadInstruction;
            result = result * 59 + ($valueLoadInstruction == null ? 43 : $valueLoadInstruction.hashCode());
            TypeDescription $loadedType = this.loadedType;
            result = result * 59 + ($loadedType == null ? 43 : $loadedType.hashCode());
            return result;
        }
    }

    protected static class ForArgument
    extends FixedValue
    implements AssignerConfigurable,
    ByteCodeAppender {
        private final int index;

        protected ForArgument(int index) {
            this(Assigner.DEFAULT, Assigner.Typing.STATIC, index);
        }

        private ForArgument(Assigner assigner, Assigner.Typing typing, int index) {
            super(assigner, typing);
            this.index = index;
        }

        @Override
        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
            if (instrumentedMethod.getParameters().size() <= this.index) {
                throw new IllegalStateException(instrumentedMethod + " does not define a parameter with index " + this.index);
            }
            ParameterDescription parameterDescription = (ParameterDescription)instrumentedMethod.getParameters().get(this.index);
            StackManipulation.Compound stackManipulation = new StackManipulation.Compound(MethodVariableAccess.load(parameterDescription), this.assigner.assign(parameterDescription.getType(), instrumentedMethod.getReturnType(), this.typing), MethodReturn.of(instrumentedMethod.getReturnType()));
            if (!stackManipulation.isValid()) {
                throw new IllegalStateException("Cannot assign " + instrumentedMethod.getReturnType() + " to " + parameterDescription);
            }
            return new ByteCodeAppender.Size(stackManipulation.apply(methodVisitor, implementationContext).getMaximalSize(), instrumentedMethod.getStackSize());
        }

        @Override
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return this;
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        @Override
        public Implementation withAssigner(Assigner assigner, Assigner.Typing typing) {
            return new ForArgument(assigner, typing, this.index);
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ForArgument)) {
                return false;
            }
            ForArgument other = (ForArgument)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            return this.index == other.index;
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ForArgument;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + super.hashCode();
            result = result * 59 + this.index;
            return result;
        }
    }

    protected static class ForThisValue
    extends FixedValue
    implements AssignerConfigurable {
        protected ForThisValue() {
            super(Assigner.DEFAULT, Assigner.Typing.STATIC);
        }

        private ForThisValue(Assigner assigner, Assigner.Typing typing) {
            super(assigner, typing);
        }

        @Override
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return new Appender(implementationTarget.getInstrumentedType());
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        @Override
        public Implementation withAssigner(Assigner assigner, Assigner.Typing typing) {
            return new ForThisValue(assigner, typing);
        }

        protected static class Appender
        implements ByteCodeAppender {
            private final TypeDescription instrumentedType;

            protected Appender(TypeDescription instrumentedType) {
                this.instrumentedType = instrumentedType;
            }

            @Override
            public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
                if (instrumentedMethod.isStatic() || !this.instrumentedType.isAssignableTo(instrumentedMethod.getReturnType().asErasure())) {
                    throw new IllegalStateException("Cannot return 'this' from " + instrumentedMethod);
                }
                return new ByteCodeAppender.Simple(MethodVariableAccess.loadThis(), MethodReturn.REFERENCE).apply(methodVisitor, implementationContext, instrumentedMethod);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Appender)) {
                    return false;
                }
                Appender other = (Appender)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                TypeDescription this$instrumentedType = this.instrumentedType;
                TypeDescription other$instrumentedType = other.instrumentedType;
                return !(this$instrumentedType == null ? other$instrumentedType != null : !this$instrumentedType.equals(other$instrumentedType));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Appender;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                TypeDescription $instrumentedType = this.instrumentedType;
                result = result * 59 + ($instrumentedType == null ? 43 : $instrumentedType.hashCode());
                return result;
            }
        }
    }

    protected static class ForOriginType
    extends FixedValue
    implements AssignerConfigurable {
        protected ForOriginType() {
            this(Assigner.DEFAULT, Assigner.Typing.STATIC);
        }

        private ForOriginType(Assigner assigner, Assigner.Typing typing) {
            super(assigner, typing);
        }

        @Override
        public Implementation withAssigner(Assigner assigner, Assigner.Typing typing) {
            return new ForOriginType(assigner, typing);
        }

        @Override
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return new Appender(implementationTarget.getOriginType().asErasure());
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        protected class Appender
        implements ByteCodeAppender {
            private final TypeDescription originType;

            protected Appender(TypeDescription originType) {
                this.originType = originType;
            }

            @Override
            public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
                return ForOriginType.this.apply(methodVisitor, implementationContext, instrumentedMethod, TypeDescription.CLASS.asGenericType(), ClassConstant.of(this.originType));
            }

            private ForOriginType getOuter() {
                return ForOriginType.this;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Appender appender = (Appender)o;
                return this.originType.equals(appender.originType) && this.getOuter().equals(appender.getOuter());
            }

            public int hashCode() {
                return 31 * this.getOuter().hashCode() + this.originType.hashCode();
            }
        }
    }

    protected static enum ForNullValue implements Implementation,
    ByteCodeAppender
    {
        INSTANCE;


        @Override
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return this;
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        @Override
        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
            if (instrumentedMethod.getReturnType().isPrimitive()) {
                throw new IllegalStateException("Cannot return null from " + instrumentedMethod);
            }
            return new ByteCodeAppender.Simple(NullConstant.INSTANCE, MethodReturn.REFERENCE).apply(methodVisitor, implementationContext, instrumentedMethod);
        }
    }

    public static interface AssignerConfigurable
    extends Implementation {
        public Implementation withAssigner(Assigner var1, Assigner.Typing var2);
    }
}

