/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.lib.bytebuddy.utility;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class StreamDrainer {
    public static final int DEFAULT_BUFFER_SIZE = 1024;
    public static final StreamDrainer DEFAULT = new StreamDrainer();
    private static final int END_OF_STREAM = -1;
    private static final int FROM_BEGINNING = 0;
    private final int bufferSize;

    public StreamDrainer() {
        this(1024);
    }

    public StreamDrainer(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public byte[] drain(InputStream inputStream) throws IOException {
        int currentRead;
        ArrayList<byte[]> previousBytes = new ArrayList<byte[]>();
        byte[] currentArray = new byte[this.bufferSize];
        int currentIndex = 0;
        do {
            if ((currentIndex += (currentRead = inputStream.read(currentArray, currentIndex, this.bufferSize - currentIndex)) > 0 ? currentRead : 0) != this.bufferSize) continue;
            previousBytes.add(currentArray);
            currentArray = new byte[this.bufferSize];
            currentIndex = 0;
        } while (currentRead != -1);
        byte[] result = new byte[previousBytes.size() * this.bufferSize + currentIndex];
        int arrayIndex = 0;
        for (byte[] previousByte : previousBytes) {
            System.arraycopy(previousByte, 0, result, arrayIndex++ * this.bufferSize, this.bufferSize);
        }
        System.arraycopy(currentArray, 0, result, arrayIndex * this.bufferSize, currentIndex);
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StreamDrainer)) {
            return false;
        }
        StreamDrainer other = (StreamDrainer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.bufferSize == other.bufferSize;
    }

    protected boolean canEqual(Object other) {
        return other instanceof StreamDrainer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.bufferSize;
        return result;
    }
}

