/*
 * Decompiled with CFR 0.152.
 */
package wmsplugin;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.gui.IconToggleButton;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.tools.I18n;
import wmsplugin.GeorefImage;
import wmsplugin.Grabber;
import wmsplugin.Help_WMSmenuAction;
import wmsplugin.Map_Rectifier_WMSmenuAction;
import wmsplugin.WMSAdjustAction;
import wmsplugin.WMSDownloadAction;
import wmsplugin.WMSGrabber;
import wmsplugin.WMSInfo;
import wmsplugin.WMSLayer;
import wmsplugin.WMSPreferenceEditor;
import wmsplugin.YAHOOGrabber;

public class WMSPlugin
extends Plugin {
    WMSLayer wmsLayer;
    static JMenu wmsJMenu;
    static ArrayList<WMSInfo> wmsList;
    static TreeMap<String, String> wmsListDefault;
    private static boolean menuEnabled;

    public WMSPlugin() {
        try {
            this.copy("/resources/ymap.html", "ymap.html");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        WMSPlugin.refreshMenu();
    }

    public void copy(String from, String to) throws FileNotFoundException, IOException {
        File pluginDir = new File(Main.pref.getPreferencesDir() + "plugins/wmsplugin/");
        if (!pluginDir.exists()) {
            pluginDir.mkdirs();
        }
        FileOutputStream out = new FileOutputStream(Main.pref.getPreferencesDir() + "plugins/wmsplugin/" + to);
        InputStream in = WMSPlugin.class.getResourceAsStream(from);
        byte[] buffer = new byte[8192];
        int len = in.read(buffer);
        while (len > 0) {
            out.write(buffer, 0, len);
            len = in.read(buffer);
        }
        in.close();
        out.close();
    }

    public static void refreshMenu() {
        wmsList.clear();
        Map prefs = Main.pref.getAllPrefix("wmsplugin.url.");
        TreeSet keys = new TreeSet(prefs.keySet());
        int prefid = 0;
        String name = null;
        String url = null;
        int lastid = -1;
        for (String key : keys) {
            String[] elements = key.split("\\.");
            if (elements.length != 4) continue;
            try {
                prefid = Integer.parseInt(elements[2]);
            }
            catch (NumberFormatException e) {
                continue;
            }
            if (prefid != lastid) {
                url = null;
                name = null;
                lastid = prefid;
            }
            if (elements[3].equals("name")) {
                name = (String)prefs.get(key);
            } else if (elements[3].equals("url")) {
                url = (String)prefs.get(key);
            }
            if (name == null || url == null) continue;
            wmsList.add(new WMSInfo(name, url, prefid));
        }
        WMSPlugin.setDefault(true, I18n.tr((String)"Landsat"), "http://onearth.jpl.nasa.gov/wms.cgi?request=GetMap&layers=global_mosaic&styles=&srs=EPSG:4326&format=image/jpeg");
        WMSPlugin.setDefault(true, I18n.tr((String)"NPE Maps"), "http://nick.dev.openstreetmap.org/openpaths/freemap.php?layers=npe&");
        WMSPlugin.setDefault(false, I18n.tr((String)"YAHOO (GNOME)"), "yahoo://gnome-web-photo --mode=photo --format=png {0} /dev/stdout");
        WMSPlugin.setDefault(false, I18n.tr((String)"YAHOO (GNOME Fix)"), "yahoo://gnome-web-photo-fixed {0}");
        WMSPlugin.setDefault(true, I18n.tr((String)"YAHOO (WebKit)"), "yahoo://webkit-image {0}");
        WMSPlugin.setDefault(false, I18n.tr((String)"YAHOO (WebKit GTK)"), "yahoo://webkit-image-gtk {0}");
        WMSPlugin.setDefault(false, I18n.tr((String)"Oberpfalz Geofabrik.de"), "http://oberpfalz.geofabrik.de/wms4josm?");
        Collections.sort(wmsList);
        MainMenu menu = Main.main.menu;
        if (wmsJMenu == null) {
            wmsJMenu = new JMenu(I18n.tr((String)"WMS"));
            menu.add(wmsJMenu, 87, "wms");
            menu.add((Component)wmsJMenu, 5);
        } else {
            wmsJMenu.removeAll();
        }
        for (WMSInfo u : wmsList) {
            wmsJMenu.add(new JMenuItem((Action)((Object)new WMSDownloadAction(u))));
        }
        wmsJMenu.addSeparator();
        wmsJMenu.add(new JMenuItem((Action)((Object)new Map_Rectifier_WMSmenuAction())));
        wmsJMenu.addSeparator();
        wmsJMenu.add(new JMenuItem((Action)new JosmAction(I18n.tr((String)"Blank Layer"), "blankmenu", I18n.tr((String)"Open a blank WMS layer to load data from a file"), null, false){

            public void actionPerformed(ActionEvent ev) {
                Main.main.addLayer((Layer)new WMSLayer());
            }
        }));
        wmsJMenu.addSeparator();
        wmsJMenu.add(new JMenuItem((Action)((Object)new Help_WMSmenuAction())));
        WMSPlugin.setEnabledAll(menuEnabled);
    }

    private static void setDefault(Boolean force, String name, String url) {
        String testurl = url.replaceAll("=", "_");
        wmsListDefault.put(name, url);
        if (force.booleanValue() && !Main.pref.getBoolean("wmsplugin.default." + testurl)) {
            Main.pref.put("wmsplugin.default." + testurl, true);
            int id = -1;
            for (WMSInfo i : wmsList) {
                if (url.equals(i.url)) {
                    return;
                }
                if (i.prefid <= id) continue;
                id = i.prefid;
            }
            WMSInfo newinfo = new WMSInfo(name, url, id + 1);
            newinfo.save();
            wmsList.add(newinfo);
        }
    }

    public static Grabber getGrabber(String _baseURL, Bounds _b, Projection _proj, double _pixelPerDegree, GeorefImage _image, MapView _mv, WMSLayer _layer) {
        if (_baseURL.startsWith("yahoo://")) {
            return new YAHOOGrabber(_baseURL, _b, _proj, _pixelPerDegree, _image, _mv, _layer);
        }
        return new WMSGrabber(_baseURL, _b, _proj, _pixelPerDegree, _image, _mv, _layer);
    }

    private static void setEnabledAll(boolean isEnabled) {
        for (int i = 0; i < wmsJMenu.getItemCount(); ++i) {
            JMenuItem item = wmsJMenu.getItem(i);
            if (item == null) continue;
            item.setEnabled(isEnabled);
        }
        menuEnabled = isEnabled;
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        if (oldFrame == null && newFrame != null) {
            WMSPlugin.setEnabledAll(true);
            Main.map.toolBarActions.addSeparator();
            Main.map.toolBarActions.add((Component)new IconToggleButton((Action)((Object)new WMSAdjustAction(Main.map))));
        } else if (oldFrame != null && newFrame == null) {
            WMSPlugin.setEnabledAll(false);
        }
    }

    public PreferenceSetting getPreferenceSetting() {
        return new WMSPreferenceEditor();
    }

    static {
        wmsList = new ArrayList();
        wmsListDefault = new TreeMap();
        menuEnabled = false;
    }
}

