/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.globalsat;

import gnu.io.CommPortIdentifier;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Enumeration;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.globalsat.GlobalsatDg100;
import org.openstreetmap.josm.plugins.globalsat.GlobalsatImportDialog;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class GlobalsatPlugin
extends Plugin {
    private static GlobalsatDg100 device = null;
    GlobalsatImportAction importAction;

    public static GlobalsatDg100 dg100() {
        return device;
    }

    public static void setPortIdent(CommPortIdentifier commPortIdentifier) {
        if (device != null) {
            device.disconnect();
        }
        device = new GlobalsatDg100(commPortIdentifier);
    }

    public GlobalsatPlugin() {
        boolean bl = false;
        try {
            Enumeration enumeration = CommPortIdentifier.getPortIdentifiers();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            bl = true;
            JOptionPane.showMessageDialog(Main.parent, "<html>" + I18n.tr((String)"Cannot load library rxtxSerial. If you need support to install it try Globalsat homepage at http://www.raphael-mack.de/josm-globalsat-gpx-import-plugin/") + "</html>");
        }
        if (!bl) {
            this.importAction = new GlobalsatImportAction();
            Main.main.menu.toolsMenu.add((Action)((Object)this.importAction));
        }
    }

    class GlobalsatImportAction
    extends JosmAction {
        public GlobalsatImportAction() {
            super(I18n.tr((String)"Globalsat Import"), "globalsatImport", I18n.tr((String)"Import Data from Globalsat Datalogger DG100 into GPXLayer."), 73, 2, false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GlobalsatImportDialog globalsatImportDialog = new GlobalsatImportDialog();
            JOptionPane jOptionPane = new JOptionPane(globalsatImportDialog, -1, 2);
            JDialog jDialog = jOptionPane.createDialog(Main.parent, I18n.tr((String)"Import"));
            globalsatImportDialog.setOptionPane(jOptionPane);
            jDialog.setVisible(true);
            if ((Integer)jOptionPane.getValue() == 0) {
                GlobalsatPlugin.setPortIdent(globalsatImportDialog.getPort());
                ImportTask importTask = new ImportTask(globalsatImportDialog.deleteFilesAfterDownload());
                Main.worker.execute((Runnable)((Object)importTask));
            }
            jDialog.dispose();
        }
    }

    private static class ImportTask
    extends PleaseWaitRunnable {
        public GpxData data;
        public Exception eee;
        private boolean deleteAfter;

        public ImportTask(boolean bl) {
            super(I18n.tr((String)"Importing data from device."));
            this.deleteAfter = bl;
        }

        public void realRun() throws IOException, SAXException {
            Main.pleaseWaitDlg.progress.setValue(0);
            Main.pleaseWaitDlg.currentAction.setText(I18n.tr((String)"Importing data from DG100..."));
            try {
                this.data = GlobalsatPlugin.dg100().readData();
            }
            catch (Exception exception) {
                this.eee = exception;
            }
        }

        protected void finish() {
            if (this.deleteAfter && !GlobalsatPlugin.dg100().isCancelled()) {
                Main.pref.put("globalsat.deleteAfterDownload", true);
                try {
                    GlobalsatPlugin.dg100().deleteData();
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Error deleting data.") + " " + exception.toString());
                }
            } else {
                Main.pref.put("globalsat.deleteAfterDownload", false);
            }
            if (this.data != null && this.data.hasTrackPoints()) {
                Main.main.addLayer((Layer)new GpxLayer(this.data, I18n.tr((String)"imported data from {0}", (Object[])new Object[]{"DG 100"})));
                Main.map.repaint();
            } else {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"No data found on device."));
            }
            if (this.eee != null) {
                this.eee.printStackTrace();
                System.out.println(this.eee.getMessage());
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Connection failed.") + " (" + this.eee.toString() + ")");
            }
            GlobalsatPlugin.dg100().disconnect();
        }

        protected void cancel() {
            GlobalsatPlugin.dg100().cancel();
            GlobalsatPlugin.dg100().disconnect();
        }
    }
}

