/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.measurement;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.measurement.MeasurementLayer;
import org.openstreetmap.josm.plugins.measurement.MeasurementPlugin;
import org.openstreetmap.josm.tools.I18n;

public class MeasurementMode
extends MapMode {
    private static final long serialVersionUID = 3853830673475744263L;

    public MeasurementMode(MapFrame mapFrame, String string, String string2) {
        super(string, "measurement.png", string2, mapFrame, Cursor.getPredefinedCursor(1));
    }

    public void enterMode() {
        super.enterMode();
        Main.map.mapView.addMouseListener((MouseListener)((Object)this));
    }

    public void exitMode() {
        super.exitMode();
        Main.map.mapView.removeMouseListener((MouseListener)((Object)this));
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 3) {
            MeasurementPlugin.getCurrentLayer().removeLastPoint();
        } else if (mouseEvent.getButton() == 1) {
            LatLon latLon = Main.map.mapView.getLatLon(mouseEvent.getX(), mouseEvent.getY());
            if (latLon.isOutSideWorld()) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Can not draw outside of the world."));
                return;
            }
            if (MeasurementPlugin.currentLayer == null) {
                Main.main.addLayer((Layer)new MeasurementLayer("Measurement"));
            }
            MeasurementPlugin.currentLayer.mouseClicked(mouseEvent);
        }
    }
}

