/*
 * Decompiled with CFR 0.152.
 */
package at.dallermassl.josm.plugin.pluginmanager;

import at.dallermassl.josm.plugin.pluginmanager.PluginDescription;
import at.dallermassl.josm.plugin.pluginmanager.PluginTableModel;
import at.dallermassl.josm.plugin.pluginmanager.PluginUpdateFrame;
import at.dallermassl.josm.plugin.pluginmanager.SiteDescription;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallPanel
extends JPanel
implements ListSelectionListener {
    private JTable table;
    private PluginTableModel pluginModel;
    private JScrollPane scrollpane;
    private JTextArea infoBox;

    public InstallPanel(PluginUpdateFrame pluginUpdateFrame, List<SiteDescription> descriptions) {
        super(new BorderLayout(12, 12));
        this.setBorder(new EmptyBorder(12, 12, 12, 12));
        final JSplitPane split = new JSplitPane(0, true);
        this.pluginModel = new PluginTableModel(descriptions);
        this.table = new JTable(this.pluginModel);
        this.table.setShowGrid(false);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        this.table.setRowHeight(this.table.getRowHeight() + 2);
        this.table.setPreferredScrollableViewportSize(new Dimension(500, 200));
        this.table.getSelectionModel().addListSelectionListener(this);
        TableColumn col1 = this.table.getColumnModel().getColumn(0);
        TableColumn col2 = this.table.getColumnModel().getColumn(1);
        TableColumn col3 = this.table.getColumnModel().getColumn(2);
        col1.setPreferredWidth(30);
        col1.setMinWidth(30);
        col1.setMaxWidth(30);
        col1.setResizable(false);
        col2.setPreferredWidth(180);
        col3.setPreferredWidth(130);
        this.scrollpane = new JScrollPane(this.table);
        this.scrollpane.getViewport().setBackground(this.table.getBackground());
        split.setTopComponent(this.scrollpane);
        this.infoBox = new JTextArea();
        JScrollPane infoPane = new JScrollPane(this.infoBox);
        infoPane.setPreferredSize(new Dimension(500, 100));
        split.setBottomComponent(infoPane);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                split.setDividerLocation(0.75);
            }
        });
        this.add("Center", split);
    }

    public void install() {
        System.out.println("Installing selected plugins");
        this.pluginModel.install();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        String text = "";
        if (this.table.getSelectedRowCount() == 1) {
            PluginDescription plugin = this.pluginModel.getPlugins().get(this.table.getSelectedRow());
            text = plugin.getDescription();
        }
        this.infoBox.setText(text);
        this.infoBox.setCaretPosition(0);
    }
}

