/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.validator.util;

import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgregatePrimitivesVisitor
implements Visitor {
    Collection<OsmPrimitive> aggregatedData = new TreeSet<OsmPrimitive>(new PrimitiveComparator());

    public Collection<OsmPrimitive> visit(Collection<OsmPrimitive> data) {
        for (OsmPrimitive osm : data) {
            osm.visit((Visitor)this);
        }
        return this.aggregatedData;
    }

    public void visit(Node n) {
        this.aggregatedData.add((OsmPrimitive)n);
    }

    public void visit(Way w) {
        this.aggregatedData.add((OsmPrimitive)w);
        for (Node n : w.nodes) {
            this.visit(n);
        }
    }

    public void visit(Relation r) {
        if (!this.aggregatedData.contains(r)) {
            this.aggregatedData.add((OsmPrimitive)r);
            for (RelationMember m : r.members) {
                m.member.visit((Visitor)this);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PrimitiveComparator
    implements Comparator<OsmPrimitive> {
        PrimitiveComparator() {
        }

        @Override
        public int compare(OsmPrimitive o1, OsmPrimitive o2) {
            if (o1 instanceof Node) {
                return o2 instanceof Node ? o1.hashCode() - o2.hashCode() : -1;
            }
            if (o1 instanceof Way) {
                return o2 instanceof Way ? o1.hashCode() - o2.hashCode() : 1;
            }
            return o1.hashCode() - o2.hashCode();
        }
    }
}

