/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AvoidEscapedUnicodeCharactersCheck
extends AbstractCheck {
    public static final String MSG_KEY = "forbid.escaped.unicode.char";
    private static final Pattern UNICODE_REGEXP = Pattern.compile("\\\\u[a-fA-F0-9]{4}");
    private static final Pattern UNICODE_CONTROL = Pattern.compile("\\\\(u|U)(00[0-1][0-9A-Fa-f]|00[8-9][0-9A-Fa-f]|00(a|A)(d|D)|034(f|F)|070(f|F)|180(e|E)|200[b-fB-F]|202[a-eA-E]|206[0-4a-fA-F]|[fF]{3}[9a-bA-B]|[fF][eE][fF]{2})");
    private static final Pattern ALL_ESCAPED_CHARS = Pattern.compile("^((\\\\u)[a-fA-F0-9]{4}||\\\\b|\\\\t|\\\\n|\\\\f|\\\\r|\\\\|\"|')+$");
    private static final Pattern ESCAPED_BACKSLASH = Pattern.compile("\\\\\\\\");
    private static final Pattern NON_PRINTABLE_CHARS = Pattern.compile("\\\\u1680|\\\\u2028|\\\\u2029|\\\\u205(f|F)|\\\\u3000|\\\\u2007|\\\\u2000|\\\\u200(a|A)|\\\\u007(F|f)|\\\\u009(f|F)|\\\\u(f|F){4}|\\\\u007(F|f)|\\\\u00(a|A)(d|D)|\\\\u0600|\\\\u061(c|C)|\\\\u06(d|D){2}|\\\\u070(f|F)|\\\\u1680|\\\\u180(e|E)|\\\\u2000|\\\\u2028|\\\\u205(f|F)|\\\\u2066|\\\\u2067|\\\\u2068|\\\\u2069|\\\\u206(a|A)|\\\\u(d|D)800|\\\\u(f|F)(e|E)(f|F){2}|\\\\u(f|F){3}9|\\\\u(f|F){3}(a|A)|\\\\u0020|\\\\u00(a|A)0|\\\\u00(a|A)(d|D)|\\\\u0604|\\\\u061(c|C)|\\\\u06(d|D){2}|\\\\u070(f|F)|\\\\u1680|\\\\u180(e|E)|\\\\u200(f|F)|\\\\u202(f|F)|\\\\u2064|\\\\u2066|\\\\u2067|\\\\u2068|\\\\u2069|\\\\u206(f|F)|\\\\u(f|F)8(f|F){2}|\\\\u(f|F)(e|E)(f|F){2}|\\\\u(f|F){3}9|\\\\u(f|F){3}(b|B)|\\\\u05(d|D)0|\\\\u05(f|F)3|\\\\u0600|\\\\u0750|\\\\u0(e|E)00|\\\\u1(e|E)00|\\\\u2100|\\\\u(f|F)(b|B)50|\\\\u(f|F)(e|E)70|\\\\u(F|f){2}61|\\\\u04(f|F)9|\\\\u05(b|B)(e|E)|\\\\u05(e|E)(a|A)|\\\\u05(f|F)4|\\\\u06(f|F){2}|\\\\u077(f|F)|\\\\u0(e|E)7(f|F)|\\\\u20(a|A)(f|F)|\\\\u213(a|A)|\\\\u0000|\\\\u(f|F)(d|D)(f|F){2}|\\\\u(f|F)(e|E)(f|F){2}|\\\\u(f|F){2}(d|D)(c|C)|\\\\u2002|\\\\u0085|\\\\u200(a|A)|\\\\u2005|\\\\u2000|\\\\u2029|\\\\u000(B|b)|\\\\u2008|\\\\u2003|\\\\u205(f|F)|\\\\u1680|\\\\u0009|\\\\u0020|\\\\u2006|\\\\u2001|\\\\u202(f|F)|\\\\u00(a|A)0|\\\\u000(c|C)|\\\\u2009|\\\\u2004|\\\\u2028|\\\\u2028|\\\\u2007|\\\\u2004|\\\\u2028|\\\\u2007|\\\\u2025|\\\\u(f|F){2}0(e|E)|\\\\u(f|F){2}61");
    private Map<Integer, TextBlock> singlelineComments;
    private Map<Integer, List<TextBlock>> blockComments;
    private boolean allowEscapesForControlCharacters;
    private boolean allowByTailComment;
    private boolean allowIfAllCharactersEscaped;
    private boolean allowNonPrintableEscapes;

    public final void setAllowEscapesForControlCharacters(boolean allow) {
        this.allowEscapesForControlCharacters = allow;
    }

    public final void setAllowByTailComment(boolean allow) {
        this.allowByTailComment = allow;
    }

    public final void setAllowIfAllCharactersEscaped(boolean allow) {
        this.allowIfAllCharactersEscaped = allow;
    }

    public final void setAllowNonPrintableEscapes(boolean allow) {
        this.allowNonPrintableEscapes = allow;
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{139, 138};
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.singlelineComments = this.getFileContents().getSingleLineComments();
        this.blockComments = this.getFileContents().getBlockComments();
    }

    @Override
    public void visitToken(DetailAST ast) {
        String literal = ast.getText();
        if (!(!AvoidEscapedUnicodeCharactersCheck.hasUnicodeChar(literal) || this.allowByTailComment && this.hasTrailComment(ast) || this.isAllCharactersEscaped(literal) || this.allowEscapesForControlCharacters && AvoidEscapedUnicodeCharactersCheck.isOnlyUnicodeValidChars(literal, UNICODE_CONTROL) || this.allowNonPrintableEscapes && AvoidEscapedUnicodeCharactersCheck.isOnlyUnicodeValidChars(literal, NON_PRINTABLE_CHARS))) {
            this.log(ast.getLineNo(), MSG_KEY, new Object[0]);
        }
    }

    private static boolean hasUnicodeChar(String literal) {
        String literalWithoutEscapedBackslashes = ESCAPED_BACKSLASH.matcher(literal).replaceAll("");
        return UNICODE_REGEXP.matcher(literalWithoutEscapedBackslashes).find();
    }

    private static boolean isOnlyUnicodeValidChars(String literal, Pattern pattern) {
        int unicodeValidMatchesCounter;
        int unicodeMatchesCounter = AvoidEscapedUnicodeCharactersCheck.countMatches(UNICODE_REGEXP, literal);
        return unicodeMatchesCounter - (unicodeValidMatchesCounter = AvoidEscapedUnicodeCharactersCheck.countMatches(pattern, literal)) == 0;
    }

    private boolean hasTrailComment(DetailAST ast) {
        boolean result = false;
        int lineNo = ast.getLineNo();
        if (this.singlelineComments.containsKey(lineNo)) {
            result = true;
        } else {
            String line = this.getLines()[lineNo - 1];
            List<TextBlock> commentList = this.blockComments.get(lineNo);
            if (commentList != null) {
                TextBlock comment = commentList.get(commentList.size() - 1);
                result = AvoidEscapedUnicodeCharactersCheck.isTrailingBlockComment(comment, line);
            }
        }
        return result;
    }

    private static boolean isTrailingBlockComment(TextBlock comment, String line) {
        return comment.getText().length != 1 || line.substring(comment.getEndColNo() + 1).trim().isEmpty();
    }

    private static int countMatches(Pattern pattern, String target) {
        int matcherCounter = 0;
        Matcher matcher = pattern.matcher(target);
        while (matcher.find()) {
            ++matcherCounter;
        }
        return matcherCounter;
    }

    private boolean isAllCharactersEscaped(String literal) {
        return this.allowIfAllCharactersEscaped && ALL_ESCAPED_CHARS.matcher(literal.substring(1, literal.length() - 1)).find();
    }
}

