/*
 * Decompiled with CFR 0.152.
 */
package com.oopsconsultancy.xmltask.output;

import com.oopsconsultancy.xmltask.output.Outputter;
import com.oopsconsultancy.xmltask.output.XMLWriter;
import java.io.Writer;
import java.util.Stack;
import javax.xml.transform.Transformer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class FormattedDataWriter
extends XMLWriter
implements LexicalHandler,
Outputter {
    private boolean escaped = true;
    private Transformer transformer = null;
    private boolean firsttime = true;
    private static final Object SEEN_NOTHING = new Object();
    private static final Object SEEN_ELEMENT = new Object();
    private static final Object SEEN_DATA = new Object();
    private Object state = SEEN_NOTHING;
    private Stack<Object> stateStack = new Stack();
    private int indentStep = 0;
    private int depth = 0;

    @Override
    public void setWriter(Writer w) {
        this.init(w);
    }

    public int getIndentStep() {
        return this.indentStep;
    }

    public void setIndentStep(int indentStep) {
        this.indentStep = indentStep;
    }

    @Override
    public void setTransformer(Transformer transformer) {
        this.transformer = transformer;
    }

    @Override
    public void reset() {
        this.depth = 0;
        this.state = SEEN_NOTHING;
        this.stateStack = new Stack();
        super.reset();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (this.firsttime) {
            this.firsttime = false;
            String pub = this.transformer.getOutputProperty("doctype-public");
            String sys = this.transformer.getOutputProperty("doctype-system");
            if (pub != null && sys != null) {
                this.write("<!DOCTYPE " + qName + " PUBLIC \"" + pub + "\" \"" + sys + "\">\n");
            } else if (sys != null) {
                this.write("<!DOCTYPE " + qName + " SYSTEM \"" + sys + "\">\n");
            }
        }
        this.stateStack.push(SEEN_ELEMENT);
        this.state = SEEN_NOTHING;
        if (this.depth > 0) {
            super.characters("\n".toCharArray(), 0, 1);
        }
        this.doIndent();
        super.startElement(uri, localName, qName, atts);
        ++this.depth;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        --this.depth;
        if (this.state == SEEN_ELEMENT) {
            super.characters("\n".toCharArray(), 0, 1);
            this.doIndent();
        }
        super.endElement(uri, localName, qName);
        this.state = this.stateStack.pop();
    }

    @Override
    public void emptyElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.state = SEEN_ELEMENT;
        if (this.depth > 0) {
            super.characters("\n".toCharArray(), 0, 1);
        }
        this.doIndent();
        super.emptyElement(uri, localName, qName, atts);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.escaped) {
            int end = start + length - 1;
            while ((ch[start] == ' ' || ch[start] == '\t' || ch[start] == '\n') && start < end) {
                ++start;
                --length;
            }
            while (length > 0 && (ch[end] == ' ' || ch[end] == '\t' || ch[end] == '\n')) {
                --end;
                --length;
            }
            if (length > 0) {
                this.state = SEEN_DATA;
            }
            super.characters(ch, start, length);
        } else {
            this.nonescapedcharacters(ch, start, length);
        }
    }

    private void doIndent() throws SAXException {
        if (this.indentStep > 0 && this.depth > 0) {
            int n = this.indentStep * this.depth;
            char[] ch = new char[n];
            int i = 0;
            while (i < n) {
                ch[i] = 32;
                ++i;
            }
            super.characters(ch, 0, n);
        }
    }

    @Override
    public void startDocument() throws SAXException {
        this.reset();
        String encoding = this.transformer.getOutputProperty("encoding");
        String standalone = this.transformer.getOutputProperty("standalone");
        this.write("<?xml version=\"1.0\" " + (encoding == null ? "UTF-8" : "encoding=\"" + encoding + "\" ") + "standalone=\"" + standalone + "\"" + "?>\n\n");
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        this.write("\n");
        this.doIndent();
        this.write("<!--");
        this.writeEsc(ch, start, length, false);
        this.write("-->\n");
    }

    @Override
    public void startCDATA() throws SAXException {
        this.doIndent();
        this.write("<![CDATA[");
        this.escaped = false;
    }

    @Override
    public void endCDATA() throws SAXException {
        this.write("]]>\n");
        this.escaped = true;
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void startDTD(String name, String pub, String sys) throws SAXException {
    }

    @Override
    public void startEntity(String name) throws SAXException {
    }

    @Override
    public void endEntity(String name) throws SAXException {
    }
}

