/*
 * Decompiled with CFR 0.152.
 */
package com.oopsconsultancy.xmltask.jdk15;

import com.oopsconsultancy.xmltask.XPathAnalyser;
import com.oopsconsultancy.xmltask.XPathAnalyserClient;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

public class XPathAnalyser15
implements XPathAnalyser {
    private XPathAnalyserClient client;
    private Object callback;
    private XPathFactory g_xpathFactory;
    private XPath m_xpath;

    public XPathAnalyser15() {
        if (this.g_xpathFactory == null) {
            try {
                this.g_xpathFactory = XPathFactory.newInstance("http://java.sun.com/jaxp/xpath/dom");
            }
            catch (Exception e) {
                System.out.println("Error: Could not initialize XPath api");
                e.printStackTrace(System.out);
            }
        }
        if (this.m_xpath == null && this.g_xpathFactory != null) {
            this.m_xpath = this.g_xpathFactory.newXPath();
        }
    }

    @Override
    public void registerClient(XPathAnalyserClient client, Object callback) {
        this.client = client;
        this.callback = callback;
    }

    @Override
    public int analyse(Node node, String xpath) throws Exception {
        int count = 0;
        Object result = null;
        try {
            result = this.m_xpath.evaluate(xpath, node, XPathConstants.NODESET);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (result instanceof NodeList) {
            NodeList nl = (NodeList)result;
            int i = 0;
            while (i < nl.getLength()) {
                Node n = nl.item(i);
                if (n instanceof ProcessingInstruction) {
                    this.client.applyNode(n.getNodeValue(), this.callback);
                } else {
                    this.client.applyNode(n, this.callback);
                }
                ++count;
                ++i;
            }
        } else {
            result = this.m_xpath.evaluate(xpath, node, XPathConstants.STRING);
            String str = (String)result;
            this.client.applyNode(str, this.callback);
            ++count;
        }
        return count;
    }
}

