/*
 * Decompiled with CFR 0.152.
 */
package com.oopsconsultancy.xmltask;

import com.oopsconsultancy.xmltask.Action;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RenameAction
extends Action {
    private final String to;

    public RenameAction(String to) {
        this.to = to;
    }

    @Override
    public boolean apply(Node node) throws Exception {
        if (node.getNodeType() == 2) {
            Attr attr = (Attr)node;
            Element owner = attr.getOwnerElement();
            owner.setAttribute(this.to, attr.getValue());
            this.remove(node);
        } else if (node.getNodeType() == 1) {
            Element elem = (Element)node;
            Node owner = elem.getParentNode();
            Element newElem = elem.getOwnerDocument().createElement(this.to);
            if (owner instanceof Document) {
                owner.removeChild(elem);
                owner.appendChild(newElem);
            } else {
                owner.insertBefore(newElem, elem.getNextSibling());
            }
            NodeList nl = elem.getChildNodes();
            int n = 0;
            while (n < nl.getLength()) {
                newElem.appendChild(nl.item(n).cloneNode(true));
                ++n;
            }
            NamedNodeMap attrs = elem.getAttributes();
            int a = 0;
            while (a < attrs.getLength()) {
                newElem.setAttributeNode((Attr)attrs.item(a).cloneNode(true));
                ++a;
            }
            if (!(owner instanceof Document)) {
                this.remove(elem);
            }
        }
        return true;
    }

    public String toString() {
        return "RenameAction(" + this.to + ")";
    }
}

