/*
 * Decompiled with CFR 0.152.
 */
package com.oopsconsultancy.xmltask;

import com.oopsconsultancy.xmltask.Action;
import com.oopsconsultancy.xmltask.BufferStore;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tools.ant.Task;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class InsertAction
extends Action {
    public static final String DUMMY = "XMLTASK";
    public static final String DUMMYNODE = "<XMLTASK>";
    public static final String DUMMYENODE = "</XMLTASK>";
    protected Document doc2;
    private DocumentBuilderFactory dfactory;
    protected Position pos;
    protected boolean wellFormed;
    protected String buffer;
    protected Task task;

    private DocumentBuilder getBuilder() throws ParserConfigurationException {
        DocumentBuilder db = this.dfactory.newDocumentBuilder();
        db.setErrorHandler(new ErrorHandler(){

            @Override
            public void error(SAXParseException e) {
                System.err.println(e.getMessage());
            }

            @Override
            public void fatalError(SAXParseException e) {
            }

            @Override
            public void warning(SAXParseException e) {
                System.err.println(e.getMessage());
            }
        });
        return db;
    }

    public static InsertAction fromString(String txml, Task task) throws Exception {
        return new InsertAction(txml, task);
    }

    public static InsertAction fromFile(File file, Task task) throws Exception {
        return new InsertAction(file, task);
    }

    public static InsertAction fromBuffer(String buffer, Task task) throws Exception {
        InsertAction ia = new InsertAction();
        ia.buffer = buffer;
        ia.task = task;
        return ia;
    }

    protected InsertAction() {
        this.doc2 = null;
        this.dfactory = DocumentBuilderFactory.newInstance();
        this.pos = Position.UNDER;
        this.wellFormed = true;
        this.buffer = null;
        this.task = null;
        this.dfactory.setNamespaceAware(true);
    }

    protected InsertAction(String txml, Task task) throws Exception {
        this.doc2 = null;
        this.dfactory = DocumentBuilderFactory.newInstance();
        this.pos = Position.UNDER;
        this.wellFormed = true;
        this.buffer = null;
        this.task = null;
        this.dfactory.setNamespaceAware(true);
        this.task = task;
        try {
            this.readXml(txml);
        }
        catch (SAXParseException e) {
            this.readXml(DUMMYNODE + txml + DUMMYENODE);
            this.wellFormed = false;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected InsertAction(File xml, Task task) throws Exception {
        block3: {
            super();
            this.doc2 = null;
            this.dfactory = DocumentBuilderFactory.newInstance();
            this.pos = Position.UNDER;
            this.wellFormed = true;
            this.buffer = null;
            this.task = null;
            this.dfactory.setNamespaceAware(true);
            this.task = task;
            in2 = new InputSource(new FileInputStream(xml));
            try {
                db = this.getBuilder();
                this.doc2 = db.parse(in2);
                break block3;
            }
            catch (SAXParseException e) {
                bfr = new BufferedReader(new FileReader(xml));
                sxml = new StringBuffer();
                ** while (bfr.ready())
            }
lbl-1000:
            // 1 sources

            {
                sxml.append(String.valueOf(bfr.readLine()) + "\n");
                continue;
            }
lbl22:
            // 1 sources

            bfr.close();
            this.readXml("<XMLTASK>" + sxml.toString() + "</XMLTASK>");
            this.wellFormed = false;
        }
    }

    protected void readXml(String xml) throws Exception {
        StringReader sr = new StringReader(xml);
        DocumentBuilder db = this.getBuilder();
        this.doc2 = db.parse(new InputSource(sr));
    }

    public void setPosition(Position val) {
        this.pos = val;
    }

    @Override
    public boolean apply(Node node) throws Exception {
        return this.insert(node);
    }

    private void log(String msg, int level) {
        if (this.task != null) {
            this.task.log(msg, level);
        } else {
            System.out.println(msg);
        }
    }

    protected boolean insert(Node node) throws Exception {
        Node newnode = null;
        if (this.buffer != null) {
            Node[] n2 = BufferStore.get(this.buffer, this.task);
            if (n2 != null) {
                if (this.pos == Position.AFTER) {
                    int n = n2.length - 1;
                    while (n >= 0) {
                        this.log("Inserting " + n2[n], 3);
                        newnode = this.doc.importNode(n2[n], true);
                        this.insertNode(node, newnode);
                        --n;
                    }
                } else {
                    int n = 0;
                    while (n < n2.length) {
                        this.log("Inserting " + n2[n], 3);
                        newnode = this.doc.importNode(n2[n], true);
                        this.insertNode(node, newnode);
                        ++n;
                    }
                }
            }
            return true;
        }
        if (this.doc2 != null) {
            newnode = this.doc.importNode(this.doc2.getDocumentElement(), true);
            if (!this.wellFormed) {
                DocumentFragment frag = this.doc.createDocumentFragment();
                NodeList children = newnode.getChildNodes();
                int c = 0;
                while (c < children.getLength()) {
                    frag.appendChild(children.item(c));
                }
                newnode = frag;
            }
            return this.insertNode(node, newnode);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean insertNode(Node existingNode, Node newnode) throws Exception {
        Node parent;
        if (this.pos == Position.UNDER) {
            if (existingNode instanceof Document) {
                this.log("Building a root element", 3);
                existingNode.appendChild(newnode);
            } else if (existingNode instanceof Element) {
                if (newnode instanceof Attr) {
                    ((Element)existingNode).setAttributeNodeNS((Attr)newnode);
                } else {
                    existingNode.appendChild(newnode);
                }
            } else {
                if (!(existingNode instanceof Attr)) {
                    System.err.println(existingNode + " not an element node");
                    return false;
                }
                if (!(newnode instanceof Text)) {
                    System.err.println(newnode + " must be a text node to insert in an attribute");
                    return false;
                }
                Attr existingAttr = (Attr)existingNode;
                existingAttr.setValue(newnode.getNodeValue());
            }
        }
        if (this.pos == Position.BEFORE) {
            parent = existingNode.getParentNode();
            if (parent == null) {
                System.err.println("Attempt to insert prior to root node");
                return false;
            }
            parent.insertBefore(newnode, existingNode);
        }
        if (this.pos == Position.AFTER) {
            parent = existingNode.getParentNode();
            if (parent == null) {
                System.err.println("Attempt to insert after root node");
                return false;
            }
            parent.insertBefore(newnode, existingNode.getNextSibling());
        }
        return true;
    }

    public String toString() {
        return "InsertAction(" + (this.doc2 == null ? (this.buffer == null ? "" : "buffer " + this.buffer) : this.doc2.getDocumentElement().toString()) + ", position [" + this.pos + "])";
    }

    public static class Position {
        private final String label;
        public static final Position UNDER = new Position("under");
        public static final Position BEFORE = new Position("before");
        public static final Position AFTER = new Position("after");

        private Position(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }
}

