/*
 * Decompiled with CFR 0.152.
 */
package com.oopsconsultancy.xmltask;

import com.oopsconsultancy.xmltask.Action;
import com.oopsconsultancy.xmltask.BufferStore;
import com.oopsconsultancy.xmltask.XPathAnalyser;
import com.oopsconsultancy.xmltask.XPathAnalyserClient;
import com.oopsconsultancy.xmltask.XPathAnalyserFactory;
import com.oopsconsultancy.xmltask.ant.Param;
import com.oopsconsultancy.xmltask.ant.XmlTask;
import java.util.List;
import org.apache.tools.ant.taskdefs.Ant;
import org.apache.tools.ant.taskdefs.Property;
import org.w3c.dom.Node;

public class CallAction
extends Action
implements XPathAnalyserClient {
    private final String target;
    private final XmlTask task;
    private final boolean inheritAll;
    private final boolean inheritRefs;
    private final String buffer;
    private final List<Param> params;
    private Ant callee;

    public CallAction(String target, XmlTask task, boolean inheritAll, boolean inheritRefs, String buffer, List<Param> params) {
        this.target = target;
        this.task = task;
        this.inheritAll = inheritAll;
        this.inheritRefs = inheritRefs;
        this.buffer = buffer;
        this.params = params;
    }

    public void init() {
        this.callee = (Ant)this.task.getProject().createTask("ant");
        this.callee.setOwningTarget(this.task.getOwningTarget());
        this.callee.setTaskName(this.task.getTaskName());
        this.callee.setLocation(this.task.getLocation());
        this.callee.init();
    }

    private void resetParams() {
        for (Param param : this.params) {
            if (param.getPath() == null) continue;
            param.setValue(null);
        }
    }

    @Override
    public void applyNode(Node n, Object callback) {
        Param param = (Param)callback;
        param.set(this.task, n.getNodeValue());
    }

    @Override
    public void applyNode(String str, Object callback) {
        Param param = (Param)callback;
        param.set(this.task, str);
    }

    @Override
    public boolean apply(Node node) throws Exception {
        Property p;
        this.init();
        this.resetParams();
        this.log("Calling target " + this.target + " for " + node + (this.buffer != null ? " (in buffer " + this.buffer : ""), 3);
        if (this.buffer != null) {
            BufferStore.set(this.buffer, node, false, this.task);
        }
        if (this.params != null) {
            for (Param param : this.params) {
                if (param.getPath() != null) {
                    XPathAnalyser xpa = XPathAnalyserFactory.getAnalyser();
                    xpa.registerClient(this, param);
                    xpa.analyse(node, param.getPath());
                }
                if (param.getValue() == null) continue;
                p = this.callee.createProperty();
                p.setName(param.getName());
                p.setValue(param.getValue());
            }
        }
        String nodeStr = this.getNodePath(node, false);
        String fqnodeStr = this.getNodePath(node, true);
        p = this.callee.createProperty();
        p.setName("xmltask.path");
        p.setValue(nodeStr);
        p = this.callee.createProperty();
        p.setName("xmltask.fqpath");
        p.setValue(fqnodeStr);
        this.callee.setAntfile(this.task.getProject().getProperty("ant.file"));
        this.callee.setTarget(this.target);
        this.callee.setInheritAll(this.inheritAll);
        this.callee.setInheritRefs(this.inheritRefs);
        Ant.Reference buffers = new Ant.Reference();
        buffers.setProject(this.task.getProject());
        buffers.setRefId("xmltask.buffers");
        buffers.setToRefid("xmltask.buffers");
        this.callee.addReference(buffers);
        this.callee.execute();
        return true;
    }

    private String getNodePath(Node node, boolean qualified) {
        String op = "";
        while (node != null && node.getParentNode() != null) {
            if (node.getNodeType() != 3) {
                op = "/" + (qualified ? node.getLocalName() : node.getNodeName()) + op;
            }
            node = node.getParentNode();
        }
        return op.toString();
    }

    public String toString() {
        return "CallAction(" + this.target + ")";
    }

    private void log(String msg, int level) {
        if (this.task != null) {
            this.task.log(msg, level);
        } else {
            System.out.println(msg);
        }
    }
}

