/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.pmd.util.StringUtil;
import org.apache.commons.io.IOUtils;

public class ClasspathClassLoader
extends URLClassLoader {
    private static final Logger LOG = Logger.getLogger(ClasspathClassLoader.class.getName());

    public ClasspathClassLoader(String classpath, ClassLoader parent) throws IOException {
        super(ClasspathClassLoader.initURLs(classpath), parent);
    }

    private static URL[] initURLs(String classpath) throws IOException {
        if (classpath == null) {
            throw new IllegalArgumentException("classpath argument cannot be null");
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        if (classpath.startsWith("file://")) {
            ClasspathClassLoader.addFileURLs(urls, new URL(classpath));
        } else {
            ClasspathClassLoader.addClasspathURLs(urls, classpath);
        }
        return urls.toArray(new URL[urls.size()]);
    }

    private static void addClasspathURLs(List<URL> urls, String classpath) throws MalformedURLException {
        StringTokenizer toker = new StringTokenizer(classpath, File.pathSeparator);
        while (toker.hasMoreTokens()) {
            String token = toker.nextToken();
            LOG.log(Level.FINE, "Adding classpath entry: <{0}>", token);
            urls.add(ClasspathClassLoader.createURLFromPath(token));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addFileURLs(List<URL> urls, URL fileURL) throws IOException {
        BufferedReader in = null;
        try {
            String line;
            in = new BufferedReader(new InputStreamReader(fileURL.openStream()));
            while ((line = in.readLine()) != null) {
                LOG.log(Level.FINE, "Read classpath entry line: <{0}>", line);
                if ((line = line.trim()).length() <= 0) continue;
                LOG.log(Level.FINE, "Adding classpath entry: <{0}>", line);
                urls.add(ClasspathClassLoader.createURLFromPath(line));
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)in);
    }

    private static URL createURLFromPath(String path) throws MalformedURLException {
        File file = new File(path);
        return file.getAbsoluteFile().toURI().toURL();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("[[");
        StringUtil.asStringOn(sb, this.getURLs(), ":");
        sb.append("] parent: ").append(this.getParent()).append(']');
        return sb.toString();
    }

    static {
        ClasspathClassLoader.registerAsParallelCapable();
    }
}

