/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.processor;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import net.sourceforge.pmd.PMDConfiguration;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.processor.AbstractPMDProcessor;
import net.sourceforge.pmd.processor.PmdRunnable;
import net.sourceforge.pmd.processor.PmdThreadFactory;
import net.sourceforge.pmd.renderers.Renderer;

public class MultiThreadProcessor
extends AbstractPMDProcessor {
    private ThreadFactory factory;
    private ExecutorService executor;
    private CompletionService<Report> completionService;
    private List<Future<Report>> tasks = new ArrayList<Future<Report>>();

    public MultiThreadProcessor(PMDConfiguration configuration) {
        super(configuration);
        this.factory = new PmdThreadFactory();
        this.executor = Executors.newFixedThreadPool(configuration.getThreads(), this.factory);
        this.completionService = new ExecutorCompletionService<Report>(this.executor);
    }

    @Override
    protected void runAnalysis(PmdRunnable runnable) {
        this.tasks.add(this.completionService.submit(runnable));
    }

    @Override
    protected void collectReports(List<Renderer> renderers) {
        try {
            for (int i = 0; i < this.tasks.size(); ++i) {
                Report report = this.completionService.take().get();
                super.renderReports(renderers, report);
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException ee) {
            Throwable t = ee.getCause();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new IllegalStateException("PmdRunnable exception", t);
        }
        finally {
            this.executor.shutdownNow();
        }
    }
}

