/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cache;

import java.io.File;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleSets;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.cache.AnalysisCache;
import net.sourceforge.pmd.cache.AnalysisResult;
import net.sourceforge.pmd.cache.CachedRuleMapper;
import net.sourceforge.pmd.stat.Metric;

public abstract class AbstractAnalysisCache
implements AnalysisCache {
    protected static final Logger LOG = Logger.getLogger(AbstractAnalysisCache.class.getName());
    protected final String pmdVersion;
    protected final ConcurrentMap<String, AnalysisResult> fileResultsCache;
    protected final ConcurrentMap<String, AnalysisResult> updatedResultsCache;
    protected long rulesetChecksum;
    protected long classpathChecksum;
    protected final CachedRuleMapper ruleMapper = new CachedRuleMapper();

    public AbstractAnalysisCache() {
        this.pmdVersion = PMD.VERSION;
        this.fileResultsCache = new ConcurrentHashMap<String, AnalysisResult>();
        this.updatedResultsCache = new ConcurrentHashMap<String, AnalysisResult>();
    }

    @Override
    public boolean isUpToDate(File sourceFile) {
        AnalysisResult updatedResult = new AnalysisResult(sourceFile);
        this.updatedResultsCache.put(sourceFile.getPath(), updatedResult);
        AnalysisResult analysisResult = (AnalysisResult)this.fileResultsCache.get(sourceFile.getPath());
        if (analysisResult == null) {
            return false;
        }
        return analysisResult.getFileChecksum() == updatedResult.getFileChecksum();
    }

    @Override
    public List<RuleViolation> getCachedViolations(File sourceFile) {
        AnalysisResult analysisResult = (AnalysisResult)this.fileResultsCache.get(sourceFile.getPath());
        if (analysisResult == null) {
            return Collections.emptyList();
        }
        return analysisResult.getViolations();
    }

    @Override
    public void analysisFailed(File sourceFile) {
        this.updatedResultsCache.remove(sourceFile.getPath());
    }

    @Override
    public void checkValidity(RuleSets ruleSets, ClassLoader classLoader) {
        long classLoaderChecksum;
        boolean cacheIsValid = true;
        if (ruleSets.getChecksum() != this.rulesetChecksum) {
            LOG.info("Analysis cache invalidated, rulesets changed.");
            cacheIsValid = false;
        }
        if (classLoader instanceof URLClassLoader) {
            URLClassLoader urlClassLoader = (URLClassLoader)classLoader;
            classLoaderChecksum = Arrays.hashCode(urlClassLoader.getURLs());
            if (cacheIsValid && classLoaderChecksum != this.classpathChecksum) {
                for (Rule r : ruleSets.getAllRules()) {
                    if (!r.usesDFA() && !r.usesTypeResolution()) continue;
                    LOG.info("Analysis cache invalidated, classpath changed.");
                    cacheIsValid = false;
                    break;
                }
            }
        } else {
            classLoaderChecksum = 0L;
        }
        if (!cacheIsValid) {
            this.fileResultsCache.clear();
        }
        this.rulesetChecksum = ruleSets.getChecksum();
        this.classpathChecksum = classLoaderChecksum;
        this.ruleMapper.initialize(ruleSets);
    }

    @Override
    public void ruleViolationAdded(RuleViolation ruleViolation) {
        AnalysisResult analysisResult = (AnalysisResult)this.updatedResultsCache.get(ruleViolation.getFilename());
        analysisResult.addViolation(ruleViolation);
    }

    @Override
    public void metricAdded(Metric metric) {
    }
}

