/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleSetReference;
import net.sourceforge.pmd.benchmark.Benchmark;
import net.sourceforge.pmd.benchmark.Benchmarker;
import net.sourceforge.pmd.cache.ChecksumAware;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.rule.RuleReference;
import net.sourceforge.pmd.util.CollectionUtil;
import net.sourceforge.pmd.util.StringUtil;
import net.sourceforge.pmd.util.filter.Filter;
import net.sourceforge.pmd.util.filter.Filters;

public class RuleSet
implements ChecksumAware {
    private static final Logger LOG = Logger.getLogger(RuleSet.class.getName());
    private static final String MISSING_RULE = "Missing rule";
    private final long checksum;
    private final List<Rule> rules;
    private final String fileName;
    private final String name;
    private final String description;
    private final List<String> excludePatterns;
    private final List<String> includePatterns;
    private final Filter<File> filter;

    private RuleSet(RuleSetBuilder builder) {
        this.checksum = builder.checksum;
        this.fileName = builder.fileName;
        this.name = builder.name;
        this.description = builder.description;
        this.rules = builder.rules;
        this.excludePatterns = Collections.unmodifiableList(builder.excludePatterns);
        this.includePatterns = Collections.unmodifiableList(builder.includePatterns);
        Filter<String> regexFilter = Filters.buildRegexFilterIncludeOverExclude(this.includePatterns, this.excludePatterns);
        this.filter = Filters.toNormalizedFileFilter(regexFilter);
    }

    public int size() {
        return this.rules.size();
    }

    public Collection<Rule> getRules() {
        return this.rules;
    }

    public boolean usesDFA(Language language) {
        for (Rule r : this.rules) {
            if (!r.getLanguage().equals(language) || !r.usesDFA()) continue;
            return true;
        }
        return false;
    }

    public Rule getRuleByName(String ruleName) {
        for (Rule r : this.rules) {
            if (!r.getName().equals(ruleName)) continue;
            return r;
        }
        return null;
    }

    public boolean applies(File file) {
        return file != null ? this.filter.filter(file) : true;
    }

    public void start(RuleContext ctx) {
        for (Rule rule : this.rules) {
            rule.start(ctx);
        }
    }

    public void apply(List<? extends Node> acuList, RuleContext ctx) {
        long start = System.nanoTime();
        for (Rule rule : this.rules) {
            try {
                if (rule.usesRuleChain() || !RuleSet.applies(rule, ctx.getLanguageVersion())) continue;
                rule.apply(acuList, ctx);
                long end = System.nanoTime();
                Benchmarker.mark(Benchmark.Rule, rule.getName(), end - start, 1L);
                start = end;
            }
            catch (RuntimeException e) {
                if (ctx.isIgnoreExceptions()) {
                    if (!LOG.isLoggable(Level.WARNING)) continue;
                    LOG.log(Level.WARNING, "Exception applying rule " + rule.getName() + " on file " + ctx.getSourceCodeFilename() + ", continuing with next rule", e);
                    continue;
                }
                throw e;
            }
        }
    }

    public static boolean applies(Rule rule, LanguageVersion languageVersion) {
        LanguageVersion min = rule.getMinimumLanguageVersion();
        LanguageVersion max = rule.getMaximumLanguageVersion();
        return !(!rule.getLanguage().equals(languageVersion.getLanguage()) || min != null && min.compareTo(languageVersion) > 0 || max != null && max.compareTo(languageVersion) < 0);
    }

    public void end(RuleContext ctx) {
        for (Rule rule : this.rules) {
            rule.end(ctx);
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof RuleSet)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        RuleSet ruleSet = (RuleSet)o;
        return this.getName().equals(ruleSet.getName()) && this.getRules().equals(ruleSet.getRules());
    }

    public int hashCode() {
        return this.getName().hashCode() + 13 * this.getRules().hashCode();
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getExcludePatterns() {
        return this.excludePatterns;
    }

    public List<String> getIncludePatterns() {
        return this.includePatterns;
    }

    public boolean usesTypeResolution(Language language) {
        for (Rule r : this.rules) {
            if (!r.getLanguage().equals(language) || !r.usesTypeResolution()) continue;
            return true;
        }
        return false;
    }

    public void removeDysfunctionalRules(Collection<Rule> collector) {
        Iterator<Rule> iter = this.rules.iterator();
        while (iter.hasNext()) {
            Rule rule = iter.next();
            if (rule.dysfunctionReason() == null) continue;
            iter.remove();
            collector.add(rule);
        }
    }

    @Override
    public long getChecksum() {
        return this.checksum;
    }

    static class RuleSetBuilder {
        public String description = "";
        public String name = "";
        public String fileName;
        private final List<Rule> rules = new ArrayList<Rule>();
        private final List<String> excludePatterns = new ArrayList<String>(0);
        private final List<String> includePatterns = new ArrayList<String>(0);
        private final long checksum;

        RuleSetBuilder(long checksum) {
            this.checksum = checksum;
        }

        RuleSetBuilder(RuleSet original) {
            this.checksum = original.getChecksum();
            this.withName(original.getName()).withDescription(original.getDescription()).withFileName(original.getFileName()).setExcludePatterns(original.getExcludePatterns()).setIncludePatterns(original.getIncludePatterns());
            this.addRuleSet(original);
        }

        public RuleSetBuilder addRule(Rule rule) {
            if (rule == null) {
                throw new IllegalArgumentException(RuleSet.MISSING_RULE);
            }
            this.rules.add(rule);
            return this;
        }

        public RuleSetBuilder addRuleReplaceIfExists(Rule rule) {
            if (rule == null) {
                throw new IllegalArgumentException(RuleSet.MISSING_RULE);
            }
            Iterator<Rule> it = this.rules.iterator();
            while (it.hasNext()) {
                Rule r = it.next();
                if (!r.getName().equals(rule.getName()) || r.getLanguage() != rule.getLanguage()) continue;
                it.remove();
            }
            this.addRule(rule);
            return this;
        }

        public RuleSetBuilder addRuleIfNotExists(Rule rule) {
            if (rule == null) {
                throw new IllegalArgumentException(RuleSet.MISSING_RULE);
            }
            boolean exists = false;
            for (Rule r : this.rules) {
                if (!r.getName().equals(rule.getName()) || r.getLanguage() != rule.getLanguage()) continue;
                exists = true;
                break;
            }
            if (!exists) {
                this.addRule(rule);
            }
            return this;
        }

        public RuleSetBuilder addRuleByReference(String ruleSetFileName, Rule rule) {
            RuleReference ruleReference;
            if (StringUtil.isEmpty(ruleSetFileName)) {
                throw new RuntimeException("Adding a rule by reference is not allowed with an empty rule set file name.");
            }
            if (rule == null) {
                throw new IllegalArgumentException("Cannot add a null rule reference to a RuleSet");
            }
            if (rule instanceof RuleReference) {
                ruleReference = (RuleReference)rule;
            } else {
                RuleSetReference ruleSetReference = new RuleSetReference();
                ruleSetReference.setRuleSetFileName(ruleSetFileName);
                ruleReference = new RuleReference();
                ruleReference.setRule(rule);
                ruleReference.setRuleSetReference(ruleSetReference);
            }
            this.rules.add(ruleReference);
            return this;
        }

        public RuleSetBuilder addRuleSet(RuleSet ruleSet) {
            this.rules.addAll(this.rules.size(), ruleSet.getRules());
            return this;
        }

        public RuleSetBuilder addRuleSetByReference(RuleSet ruleSet, boolean allRules) {
            return this.addRuleSetByReference(ruleSet, allRules, null);
        }

        public RuleSetBuilder addRuleSetByReference(RuleSet ruleSet, boolean allRules, String ... excludes) {
            if (StringUtil.isEmpty(ruleSet.getFileName())) {
                throw new RuntimeException("Adding a rule by reference is not allowed with an empty rule set file name.");
            }
            RuleSetReference ruleSetReference = new RuleSetReference(ruleSet.getFileName());
            ruleSetReference.setAllRules(allRules);
            if (excludes != null) {
                ruleSetReference.setExcludes(new HashSet<String>(Arrays.asList(excludes)));
            }
            for (Rule rule : ruleSet.getRules()) {
                RuleReference ruleReference = new RuleReference(rule, ruleSetReference);
                this.rules.add(ruleReference);
            }
            return this;
        }

        public RuleSetBuilder addExcludePattern(String aPattern) {
            if (!this.excludePatterns.contains(aPattern)) {
                this.excludePatterns.add(aPattern);
            }
            return this;
        }

        public RuleSetBuilder addExcludePatterns(Collection<String> someExcludePatterns) {
            CollectionUtil.addWithoutDuplicates(someExcludePatterns, this.excludePatterns);
            return this;
        }

        public RuleSetBuilder setExcludePatterns(Collection<String> theExcludePatterns) {
            if (!this.excludePatterns.equals(theExcludePatterns)) {
                this.excludePatterns.clear();
                CollectionUtil.addWithoutDuplicates(theExcludePatterns, this.excludePatterns);
            }
            return this;
        }

        public RuleSetBuilder addIncludePatterns(Collection<String> someIncludePatterns) {
            CollectionUtil.addWithoutDuplicates(someIncludePatterns, this.includePatterns);
            return this;
        }

        public RuleSetBuilder setIncludePatterns(Collection<String> theIncludePatterns) {
            if (!this.includePatterns.equals(theIncludePatterns)) {
                this.includePatterns.clear();
                CollectionUtil.addWithoutDuplicates(theIncludePatterns, this.includePatterns);
            }
            return this;
        }

        public RuleSetBuilder addIncludePattern(String aPattern) {
            if (!this.includePatterns.contains(aPattern)) {
                this.includePatterns.add(aPattern);
            }
            return this;
        }

        public RuleSetBuilder withFileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public RuleSetBuilder withName(String name) {
            this.name = name;
            return this;
        }

        public RuleSetBuilder withDescription(String description) {
            this.description = description;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public RuleSet build() {
            return new RuleSet(this);
        }
    }
}

