/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.gui;

import antlr.ANTLRException;
import com.puppycrawl.tools.checkstyle.TreeWalker;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.FileText;
import com.puppycrawl.tools.checkstyle.gui.ParseTreeTableModel;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class MainFrameModel {
    private final List<Integer> linesToPosition = new ArrayList<Integer>();
    private final ParseTreeTableModel parseTreeTableModel;
    private ParseMode parseMode = ParseMode.PLAIN_JAVA;
    private File currentFile;
    private String text;
    private String title = "Checkstyle GUI";
    private boolean reloadActionEnabled;

    public MainFrameModel() {
        this.parseTreeTableModel = new ParseTreeTableModel(null);
    }

    public void setParseMode(ParseMode mode) {
        this.parseMode = mode;
    }

    public ParseTreeTableModel getParseTreeTableModel() {
        return this.parseTreeTableModel;
    }

    public String getText() {
        return this.text;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isReloadActionEnabled() {
        return this.reloadActionEnabled;
    }

    public static boolean shouldAcceptFile(File file) {
        return file.isDirectory() || file.getName().endsWith(".java");
    }

    public File getLastDirectory() {
        File lastDirectory = null;
        if (this.currentFile != null) {
            lastDirectory = new File(this.currentFile.getParent());
        }
        return lastDirectory;
    }

    public File getCurrentFile() {
        return this.currentFile;
    }

    public List<Integer> getLinesToPosition() {
        ArrayList<Integer> copy = new ArrayList<Integer>(this.linesToPosition);
        return Collections.unmodifiableList(copy);
    }

    public void openFile(File file) throws CheckstyleException {
        if (file != null) {
            try {
                DetailAST parseTree;
                this.currentFile = file;
                this.title = "Checkstyle GUI : " + file.getName();
                this.reloadActionEnabled = true;
                switch (this.parseMode) {
                    case PLAIN_JAVA: {
                        parseTree = this.parseFile(file);
                        break;
                    }
                    case JAVA_WITH_COMMENTS: 
                    case JAVA_WITH_JAVADOC_AND_COMMENTS: {
                        parseTree = this.parseFileWithComments(file);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown mode: " + (Object)((Object)this.parseMode));
                    }
                }
                this.parseTreeTableModel.setParseTree(parseTree);
                this.parseTreeTableModel.setParseMode(this.parseMode);
                String[] sourceLines = this.getFileText(file).toLinesArray();
                this.linesToPosition.clear();
                this.linesToPosition.add(0);
                StringBuilder sb = new StringBuilder();
                for (String element : sourceLines) {
                    this.linesToPosition.add(sb.length());
                    sb.append(element).append(System.lineSeparator());
                }
                this.text = sb.toString();
            }
            catch (ANTLRException | IOException ex) {
                String exceptionMsg = String.format(Locale.ROOT, "%s occurred while opening file %s.", ex.getClass().getSimpleName(), file.getPath());
                throw new CheckstyleException(exceptionMsg, ex);
            }
        }
    }

    public DetailAST parseFile(File file) throws IOException, ANTLRException {
        FileText fileText = this.getFileText(file);
        FileContents contents = new FileContents(fileText);
        return TreeWalker.parse(contents);
    }

    public DetailAST parseFileWithComments(File file) throws IOException, ANTLRException {
        FileText fileText = this.getFileText(file);
        FileContents contents = new FileContents(fileText);
        return TreeWalker.parseWithComments(contents);
    }

    public FileText getFileText(File file) throws IOException {
        return new FileText(file.getAbsoluteFile(), System.getProperty("file.encoding", "UTF-8"));
    }

    public static enum ParseMode {
        PLAIN_JAVA("Plain Java"),
        JAVA_WITH_COMMENTS("Java with comments"),
        JAVA_WITH_JAVADOC_AND_COMMENTS("Java with comments and Javadocs");

        private final String description;

        private ParseMode(String descr) {
            this.description = descr;
        }

        public String toString() {
            return this.description;
        }
    }
}

