/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.Objects;

public class DefaultComesLastCheck
extends AbstractCheck {
    public static final String MSG_KEY = "default.comes.last";
    public static final String MSG_KEY_SKIP_IF_LAST_AND_SHARED_WITH_CASE = "default.comes.last.in.casegroup";
    private boolean skipIfLastAndSharedWithCase;

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{94};
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getAcceptableTokens();
    }

    public void setSkipIfLastAndSharedWithCase(boolean newValue) {
        this.skipIfLastAndSharedWithCase = newValue;
    }

    @Override
    public void visitToken(DetailAST ast) {
        DetailAST defaultGroupAST = ast.getParent();
        if (defaultGroupAST.getType() != 161 && defaultGroupAST.getType() != 5) {
            if (this.skipIfLastAndSharedWithCase) {
                if (Objects.nonNull(DefaultComesLastCheck.findNextSibling(ast, 93))) {
                    this.log(ast, MSG_KEY_SKIP_IF_LAST_AND_SHARED_WITH_CASE, new Object[0]);
                } else if (ast.getPreviousSibling() == null && Objects.nonNull(DefaultComesLastCheck.findNextSibling(defaultGroupAST, 33))) {
                    this.log(ast, MSG_KEY, new Object[0]);
                }
            } else if (Objects.nonNull(DefaultComesLastCheck.findNextSibling(defaultGroupAST, 33))) {
                this.log(ast, MSG_KEY, new Object[0]);
            }
        }
    }

    private static DetailAST findNextSibling(DetailAST ast, int tokenType) {
        DetailAST token = null;
        for (DetailAST node = ast.getNextSibling(); node != null; node = node.getNextSibling()) {
            if (node.getType() != tokenType) continue;
            token = node;
            break;
        }
        return token;
    }
}

