/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Deque;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Formatter;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Properties;
import java.util.Queue;
import java.util.Scanner;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.regex.Pattern;
import nl.jqno.equalsverifier.internal.ConditionalInstantiator;
import nl.jqno.equalsverifier.internal.Util;
import nl.jqno.equalsverifier.internal.prefabvalues.PrefabValues;
import nl.jqno.equalsverifier.internal.prefabvalues.Tuple;
import nl.jqno.equalsverifier.internal.prefabvalues.TypeTag;
import nl.jqno.equalsverifier.internal.prefabvalues.factories.CollectionFactory;
import nl.jqno.equalsverifier.internal.prefabvalues.factories.MapFactory;
import nl.jqno.equalsverifier.internal.prefabvalues.factories.PrefabValueFactory;
import nl.jqno.equalsverifier.internal.prefabvalues.factories.ReflectiveCollectionCopyFactory;
import nl.jqno.equalsverifier.internal.prefabvalues.factories.ReflectiveCollectionFactory;
import nl.jqno.equalsverifier.internal.prefabvalues.factories.ReflectiveEnumMapFactory;
import nl.jqno.equalsverifier.internal.prefabvalues.factories.ReflectiveEnumSetFactory;
import nl.jqno.equalsverifier.internal.prefabvalues.factories.ReflectiveGenericContainerFactory;
import nl.jqno.equalsverifier.internal.prefabvalues.factories.ReflectiveGuavaEnumBiMapFactory;
import nl.jqno.equalsverifier.internal.prefabvalues.factories.ReflectiveGuavaTableFactory;
import nl.jqno.equalsverifier.internal.prefabvalues.factories.ReflectiveJavaFxPropertyFactory;
import nl.jqno.equalsverifier.internal.prefabvalues.factories.ReflectiveMapFactory;

@SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC_ANON"}, justification="That would be dozens of separate classes")
public final class JavaApiPrefabValues {
    private static final String JAVAFX_COLLECTIONS_PACKAGE = "javafx.collections.";
    private static final String JAVAFX_PROPERTY_PACKAGE = "javafx.beans.property.";
    private static final String GUAVA_PACKAGE = "com.google.common.collect.";
    private static final String JODA_PACKAGE = "org.joda.time.";
    private static final Comparator<Object> OBJECT_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            return Integer.compare(o1.hashCode(), o2.hashCode());
        }
    };
    private PrefabValues prefabValues;

    private JavaApiPrefabValues(PrefabValues prefabValues) {
        this.prefabValues = prefabValues;
    }

    public static void addTo(PrefabValues prefabValues) {
        new JavaApiPrefabValues(prefabValues).addJavaClasses();
    }

    private void addJavaClasses() {
        this.addPrimitiveClasses();
        this.addClasses();
        this.addCollection();
        this.addLists();
        this.addMaps();
        this.addSets();
        this.addQueues();
        this.addJava8ApiClasses();
        this.addJavaFxClasses();
        this.addJavaxApiClasses();
        this.addGoogleGuavaMultisetCollectionsClasses();
        this.addGoogleGuavaMultimapCollectionsClasses();
        this.addGoogleGuavaBiMapCollectionsClasses();
        this.addGoogleGuavaTableCollectionClasses();
        this.addGoogleGuavaRegularCollectionsClasses();
        this.addGoogleGuavaImmutableClasses();
        this.addNewGoogleGuavaClasses();
        this.addJodaTimeClasses();
    }

    private void addPrimitiveClasses() {
        this.addValues(Boolean.TYPE, true, false);
        this.addValues(Byte.TYPE, (byte)1, (byte)2);
        this.addValues(Character.TYPE, Character.valueOf('a'), Character.valueOf('b'));
        this.addValues(Double.TYPE, 0.5, 1.0);
        this.addValues(Float.TYPE, Float.valueOf(0.5f), Float.valueOf(1.0f));
        this.addValues(Integer.TYPE, 1, 2);
        this.addValues(Long.TYPE, 1L, 2L);
        this.addValues(Short.TYPE, (short)1, (short)2);
        this.addValues(Boolean.class, true, false);
        this.addValues(Byte.class, (byte)1, (byte)2);
        this.addValues(Character.class, Character.valueOf('a'), Character.valueOf('b'));
        this.addValues(Double.class, 0.5, 1.0);
        this.addValues(Float.class, Float.valueOf(0.5f), Float.valueOf(1.0f));
        this.addValues(Integer.class, 1, 2);
        this.addValues(Long.class, 1L, 2L);
        this.addValues(Short.class, (short)1, (short)2);
        this.addValues(Object.class, new Object(), new Object());
        this.addValues(Class.class, Class.class, Object.class);
        this.addValues(String.class, "one", "two");
        this.addValues(Enum.class, (Object)Dummy.RED, (Object)Dummy.BLACK);
    }

    @SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"}, justification="Just need an instance, not for actual use.")
    private void addClasses() {
        this.addValues(BigDecimal.class, BigDecimal.ZERO, BigDecimal.ONE);
        this.addValues(BigInteger.class, BigInteger.ZERO, BigInteger.ONE);
        this.addValues(Calendar.class, new GregorianCalendar(2010, 7, 4), new GregorianCalendar(2010, 7, 5));
        this.addValues(Date.class, new Date(0L), new Date(1L));
        this.addValues(DateFormat.class, DateFormat.getTimeInstance(), DateFormat.getDateInstance());
        this.addValues(File.class, new File(""), new File("/"));
        this.addValues(Formatter.class, new Formatter(), new Formatter());
        this.addValues(GregorianCalendar.class, new GregorianCalendar(2010, 7, 4), new GregorianCalendar(2010, 7, 5));
        this.addValues(Locale.class, new Locale("nl"), new Locale("hu"));
        this.addValues(Pattern.class, Pattern.compile("one"), Pattern.compile("two"));
        this.addValues(SimpleDateFormat.class, new SimpleDateFormat("yMd"), new SimpleDateFormat("dMy"));
        this.addValues(Scanner.class, new Scanner("one"), new Scanner("two"));
        this.addValues(TimeZone.class, TimeZone.getTimeZone("GMT+1"), TimeZone.getTimeZone("GMT+2"));
        this.addValues(Throwable.class, new Throwable(), new Throwable());
        this.addValues(UUID.class, new UUID(0L, -1L), new UUID(1L, 0L));
        ConditionalInstantiator inetAddress = new ConditionalInstantiator("java.net.InetAddress");
        this.addValues(inetAddress.resolve(), inetAddress.callFactory("getByName", Util.classes(String.class), Util.objects("127.0.0.1")), inetAddress.callFactory("getByName", Util.classes(String.class), Util.objects("127.0.0.42")));
    }

    private void addCollection() {
        this.addFactory(Iterable.class, new CollectionFactory(){

            public Collection createEmpty() {
                return new ArrayList();
            }
        });
        this.addFactory(Collection.class, new CollectionFactory<Collection>(){

            @Override
            public Collection createEmpty() {
                return new ArrayList();
            }
        });
    }

    private void addLists() {
        this.addFactory(List.class, new CollectionFactory<List>(){

            @Override
            public List createEmpty() {
                return new ArrayList();
            }
        });
        this.addFactory(CopyOnWriteArrayList.class, new CollectionFactory<CopyOnWriteArrayList>(){

            @Override
            public CopyOnWriteArrayList createEmpty() {
                return new CopyOnWriteArrayList();
            }
        });
        this.addFactory(LinkedList.class, new CollectionFactory<LinkedList>(){

            @Override
            public LinkedList createEmpty() {
                return new LinkedList();
            }
        });
        this.addFactory(ArrayList.class, new CollectionFactory<ArrayList>(){

            @Override
            public ArrayList createEmpty() {
                return new ArrayList();
            }
        });
        this.addFactory(Vector.class, new CollectionFactory<Vector>(){

            @Override
            public Vector createEmpty() {
                return new Vector();
            }
        });
        this.addFactory(Stack.class, new CollectionFactory<Stack>(){

            @Override
            public Stack createEmpty() {
                return new Stack();
            }
        });
    }

    private void addMaps() {
        this.addFactory(Map.class, new MapFactory<Map>(){

            @Override
            public Map createEmpty() {
                return new HashMap();
            }
        });
        this.addFactory(SortedMap.class, new MapFactory<SortedMap>(){

            @Override
            public SortedMap createEmpty() {
                return new TreeMap(OBJECT_COMPARATOR);
            }
        });
        this.addFactory(NavigableMap.class, new MapFactory<NavigableMap>(){

            @Override
            public NavigableMap createEmpty() {
                return new TreeMap(OBJECT_COMPARATOR);
            }
        });
        this.addFactory(ConcurrentNavigableMap.class, new MapFactory<ConcurrentNavigableMap>(){

            @Override
            public ConcurrentNavigableMap createEmpty() {
                return new ConcurrentSkipListMap(OBJECT_COMPARATOR);
            }
        });
        this.addFactory(ConcurrentHashMap.class, new MapFactory<ConcurrentHashMap>(){

            @Override
            public ConcurrentHashMap createEmpty() {
                return new ConcurrentHashMap();
            }
        });
        this.addFactory(HashMap.class, new MapFactory<HashMap>(){

            @Override
            public HashMap createEmpty() {
                return new HashMap();
            }
        });
        this.addFactory(Hashtable.class, new MapFactory<Hashtable>(){

            @Override
            public Hashtable createEmpty() {
                return new Hashtable();
            }
        });
        this.addFactory(LinkedHashMap.class, new MapFactory<LinkedHashMap>(){

            @Override
            public LinkedHashMap createEmpty() {
                return new LinkedHashMap();
            }
        });
        this.addFactory(Properties.class, new MapFactory<Properties>(){

            @Override
            public Properties createEmpty() {
                return new Properties();
            }
        });
        this.addFactory(TreeMap.class, new MapFactory<TreeMap>(){

            @Override
            public TreeMap createEmpty() {
                return new TreeMap(OBJECT_COMPARATOR);
            }
        });
        this.addFactory(WeakHashMap.class, new MapFactory<WeakHashMap>(){

            @Override
            public WeakHashMap createEmpty() {
                return new WeakHashMap();
            }
        });
        this.addFactory(EnumMap.class, new ReflectiveEnumMapFactory());
    }

    private void addSets() {
        this.addFactory(Set.class, new CollectionFactory<Set>(){

            @Override
            public Set createEmpty() {
                return new HashSet();
            }
        });
        this.addFactory(SortedSet.class, new CollectionFactory<SortedSet>(){

            @Override
            public SortedSet createEmpty() {
                return new TreeSet(OBJECT_COMPARATOR);
            }
        });
        this.addFactory(NavigableSet.class, new CollectionFactory<NavigableSet>(){

            @Override
            public NavigableSet createEmpty() {
                return new TreeSet(OBJECT_COMPARATOR);
            }
        });
        this.addFactory(CopyOnWriteArraySet.class, new CollectionFactory<CopyOnWriteArraySet>(){

            @Override
            public CopyOnWriteArraySet createEmpty() {
                return new CopyOnWriteArraySet();
            }
        });
        this.addFactory(TreeSet.class, new CollectionFactory<TreeSet>(){

            @Override
            public TreeSet createEmpty() {
                return new TreeSet(OBJECT_COMPARATOR);
            }
        });
        this.addFactory(EnumSet.class, new ReflectiveEnumSetFactory());
        BitSet redBitSet = new BitSet();
        BitSet blackBitSet = new BitSet();
        blackBitSet.set(0);
        this.addValues(BitSet.class, redBitSet, blackBitSet);
    }

    private void addQueues() {
        this.addFactory(Queue.class, new CollectionFactory<Queue>(){

            @Override
            public Queue createEmpty() {
                return new ArrayBlockingQueue(1);
            }
        });
        this.addFactory(BlockingQueue.class, new CollectionFactory<BlockingQueue>(){

            @Override
            public BlockingQueue createEmpty() {
                return new ArrayBlockingQueue(1);
            }
        });
        this.addFactory(Deque.class, new CollectionFactory<Deque>(){

            @Override
            public Deque createEmpty() {
                return new ArrayDeque(1);
            }
        });
        this.addFactory(BlockingDeque.class, new CollectionFactory<BlockingDeque>(){

            @Override
            public BlockingDeque createEmpty() {
                return new LinkedBlockingDeque(1);
            }
        });
        this.addFactory(ArrayBlockingQueue.class, new CollectionFactory<ArrayBlockingQueue>(){

            @Override
            public ArrayBlockingQueue createEmpty() {
                return new ArrayBlockingQueue(1);
            }
        });
        this.addFactory(ConcurrentLinkedQueue.class, new CollectionFactory<ConcurrentLinkedQueue>(){

            @Override
            public ConcurrentLinkedQueue createEmpty() {
                return new ConcurrentLinkedQueue();
            }
        });
        this.addFactory(DelayQueue.class, new PrefabValueFactory<DelayQueue>(){

            @Override
            public Tuple<DelayQueue> createValues(TypeTag tag, PrefabValues pf, LinkedHashSet<TypeTag> typeStack) {
                TypeTag delayed = new TypeTag(Delayed.class, new TypeTag[0]);
                DelayQueue<Delayed> red = new DelayQueue<Delayed>();
                red.add((Delayed)pf.giveRed(delayed));
                DelayQueue<Delayed> black = new DelayQueue<Delayed>();
                black.add((Delayed)pf.giveBlack(delayed));
                return new Tuple<DelayQueue>(red, black);
            }
        });
        this.addFactory(LinkedBlockingQueue.class, new CollectionFactory<LinkedBlockingQueue>(){

            @Override
            public LinkedBlockingQueue createEmpty() {
                return new LinkedBlockingQueue(1);
            }
        });
        this.addFactory(PriorityBlockingQueue.class, new CollectionFactory<PriorityBlockingQueue>(){

            @Override
            public PriorityBlockingQueue createEmpty() {
                return new PriorityBlockingQueue(1, OBJECT_COMPARATOR);
            }
        });
        this.addValues(SynchronousQueue.class, new SynchronousQueue(), new SynchronousQueue());
    }

    private void addJava8ApiClasses() {
        String optional = "java.util.Optional";
        this.addFactory(Util.classForName(optional), new ReflectiveGenericContainerFactory(optional, "of", Object.class));
        ConditionalInstantiator zoneId = new ConditionalInstantiator("java.time.ZoneId");
        this.addValues(zoneId.resolve(), zoneId.callFactory("of", Util.classes(String.class), Util.objects("+1")), zoneId.callFactory("of", Util.classes(String.class), Util.objects("-10")));
        ConditionalInstantiator dateTimeFormatter = new ConditionalInstantiator("java.time.format.DateTimeFormatter");
        this.addValues(dateTimeFormatter.resolve(), dateTimeFormatter.returnConstant("ISO_TIME"), dateTimeFormatter.returnConstant("ISO_DATE"));
        ConditionalInstantiator completableFuture = new ConditionalInstantiator("java.util.concurrent.CompletableFuture");
        this.addValues(completableFuture.resolve(), completableFuture.instantiate(Util.classes(new Class[0]), Util.objects(new Object[0])), completableFuture.instantiate(Util.classes(new Class[0]), Util.objects(new Object[0])));
        ConditionalInstantiator stampedLock = new ConditionalInstantiator("java.util.concurrent.locks.StampedLock");
        this.addValues(stampedLock.resolve(), stampedLock.instantiate(Util.classes(new Class[0]), Util.objects(new Object[0])), stampedLock.instantiate(Util.classes(new Class[0]), Util.objects(new Object[0])));
    }

    private void addJavaFxClasses() {
        this.addJavaFxCollection("ObservableList", List.class, "observableList");
        this.addJavaFxCollection("ObservableMap", Map.class, "observableMap");
        this.addJavaFxCollection("ObservableSet", Set.class, "observableSet");
        this.addJavaFxProperty("BooleanProperty", "SimpleBooleanProperty", Boolean.TYPE);
        this.addJavaFxProperty("DoubleProperty", "SimpleDoubleProperty", Double.TYPE);
        this.addJavaFxProperty("FloatProperty", "SimpleFloatProperty", Float.TYPE);
        this.addJavaFxProperty("IntegerProperty", "SimpleIntegerProperty", Integer.TYPE);
        this.addJavaFxProperty("ListProperty", "SimpleListProperty", Util.classForName("javafx.collections.ObservableList"));
        this.addJavaFxProperty("LongProperty", "SimpleLongProperty", Long.TYPE);
        this.addJavaFxProperty("MapProperty", "SimpleMapProperty", Util.classForName("javafx.collections.ObservableMap"));
        this.addJavaFxProperty("ObjectProperty", "SimpleObjectProperty", Object.class);
        this.addJavaFxProperty("SetProperty", "SimpleSetProperty", Util.classForName("javafx.collections.ObservableSet"));
        this.addJavaFxProperty("StringProperty", "SimpleStringProperty", String.class);
    }

    private void addJavaxApiClasses() {
        ConditionalInstantiator reference = new ConditionalInstantiator("javax.naming.Reference");
        this.addValues(reference.resolve(), reference.instantiate(Util.classes(String.class), Util.objects("one")), reference.instantiate(Util.classes(String.class), Util.objects("two")));
    }

    private void addGoogleGuavaMultisetCollectionsClasses() {
        this.addNewGuavaCollection("Multiset", "HashMultiset");
        this.addNewGuavaCollection("SortedMultiset", "TreeMultiset", Comparator.class, OBJECT_COMPARATOR);
        this.addNewGuavaCollection("HashMultiset", "HashMultiset");
        this.addNewGuavaCollection("TreeMultiset", "TreeMultiset", Comparator.class, OBJECT_COMPARATOR);
        this.addNewGuavaCollection("LinkedHashMultiset", "LinkedHashMultiset");
        this.addNewGuavaCollection("ConcurrentHashMultiset", "ConcurrentHashMultiset");
        this.addCopiedGuavaCollection("EnumMultiset", Iterable.class, EnumSet.class, "create");
        this.addCopiedGuavaCollection("ImmutableMultiset", Iterable.class);
        this.addCopiedGuavaCollection("ImmutableSortedMultiset", Util.classForName("com.google.common.collect.SortedMultiset"), "copyOfSorted");
    }

    private void addGoogleGuavaMultimapCollectionsClasses() {
        this.addNewGuavaMap("Multimap", "ArrayListMultimap");
        this.addNewGuavaMap("ListMultimap", "ArrayListMultimap");
        this.addNewGuavaMap("SetMultimap", "HashMultimap");
        this.addNewGuavaMap("SortedSetMultimap", "TreeMultimap", OBJECT_COMPARATOR);
        this.addNewGuavaMap("ArrayListMultimap", "ArrayListMultimap");
        this.addNewGuavaMap("HashMultimap", "HashMultimap");
        this.addNewGuavaMap("LinkedListMultimap", "LinkedListMultimap");
        this.addNewGuavaMap("LinkedHashMultimap", "LinkedHashMultimap");
        this.addNewGuavaMap("TreeMultimap", "TreeMultimap", OBJECT_COMPARATOR);
        this.addCopiedGuavaCollection("ImmutableListMultimap", Util.classForName("com.google.common.collect.Multimap"));
        this.addCopiedGuavaCollection("ImmutableSetMultimap", Util.classForName("com.google.common.collect.Multimap"));
        ConditionalInstantiator ci = new ConditionalInstantiator("com.google.common.collect.Multimap");
        this.addCopiedGuavaCollection("ImmutableMultimap", "ImmutableListMultimap", ci.resolve(), ci.resolve(), "copyOf");
    }

    private void addGoogleGuavaBiMapCollectionsClasses() {
        this.addNewGuavaMap("BiMap", "HashBiMap");
        this.addNewGuavaMap("HashBiMap", "HashBiMap");
        this.addCopiedGuavaCollection("EnumHashBiMap", Map.class, EnumMap.class, "create");
        this.addCopiedGuavaCollection("ImmutableBiMap", Map.class);
        this.addFactory(Util.classForName("com.google.common.collect.EnumBiMap"), new ReflectiveGuavaEnumBiMapFactory());
    }

    private void addGoogleGuavaTableCollectionClasses() {
        this.addNewGuavaTable("Table", "HashBasedTable");
        this.addNewGuavaTable("HashBasedTable", "HashBasedTable");
        this.addNewGuavaTable("TreeBasedTable", "TreeBasedTable", OBJECT_COMPARATOR);
        this.addCopiedGuavaCollection("ArrayTable", Util.classForName("com.google.common.collect.Table"), "create");
        this.addCopiedGuavaCollection("ImmutableTable", Util.classForName("com.google.common.collect.Table"));
    }

    private void addGoogleGuavaRegularCollectionsClasses() {
        this.addNewGuavaCollection("EvictingQueue", "EvictingQueue", Integer.TYPE, 10);
        this.addNewGuavaCollection("MinMaxPriorityQueue", "MinMaxPriorityQueue");
        ConditionalInstantiator range = new ConditionalInstantiator("com.google.common.collect.Range");
        ConditionalInstantiator rangeSet = new ConditionalInstantiator("com.google.common.collect.RangeSet");
        ConditionalInstantiator immutableRangeSet = new ConditionalInstantiator("com.google.common.collect.ImmutableRangeSet");
        this.addCopiedGuavaCollection("ImmutableRangeSet", range.resolve(), "of");
        this.addCopiedGuavaCollection("TreeRangeSet", rangeSet.resolve(), immutableRangeSet.resolve(), "create");
        this.addCopiedGuavaCollection("RangeSet", "TreeRangeSet", rangeSet.resolve(), immutableRangeSet.resolve(), "create");
    }

    private void addGoogleGuavaImmutableClasses() {
        this.addCopiedGuavaCollection("ImmutableCollection", "ImmutableList", Collection.class, Collection.class, "copyOf");
        this.addCopiedGuavaCollection("ImmutableList", Collection.class);
        this.addCopiedGuavaCollection("ImmutableMap", Map.class);
        this.addCopiedGuavaCollection("ImmutableSet", Collection.class);
        this.addCopiedGuavaCollection("ImmutableSortedMap", Map.class);
        this.addCopiedGuavaCollection("ImmutableSortedSet", Collection.class);
    }

    private void addNewGoogleGuavaClasses() {
        String rangeFqcn = "com.google.common.collect.Range";
        ConditionalInstantiator range = new ConditionalInstantiator(rangeFqcn, false);
        this.addFactory(range.resolve(), new ReflectiveGenericContainerFactory(rangeFqcn, "atLeast", Comparable.class));
        String optional = "com.google.common.base.Optional";
        this.addFactory(Util.classForName(optional), new ReflectiveGenericContainerFactory(optional, "of", Object.class));
    }

    private void addJodaTimeClasses() {
        ConditionalInstantiator chronology = new ConditionalInstantiator("org.joda.time.Chronology");
        this.addValues(chronology.resolve(), chronology.callFactory("org.joda.time.chrono.GregorianChronology", "getInstanceUTC", Util.classes(new Class[0]), Util.objects(new Object[0])), chronology.callFactory("org.joda.time.chrono.ISOChronology", "getInstanceUTC", Util.classes(new Class[0]), Util.objects(new Object[0])));
        ConditionalInstantiator dateTimeZone = new ConditionalInstantiator("org.joda.time.DateTimeZone");
        this.addValues(dateTimeZone.resolve(), dateTimeZone.callFactory("forOffsetHours", Util.classes(Integer.TYPE), Util.objects(1)), dateTimeZone.callFactory("forOffsetHours", Util.classes(Integer.TYPE), Util.objects(-10)));
        ConditionalInstantiator periodType = new ConditionalInstantiator("org.joda.time.PeriodType");
        this.addValues(periodType.resolve(), periodType.callFactory("days", Util.classes(new Class[0]), Util.objects(new Object[0])), periodType.callFactory("hours", Util.classes(new Class[0]), Util.objects(new Object[0])));
        ConditionalInstantiator yearMonth = new ConditionalInstantiator("org.joda.time.YearMonth");
        this.addValues(yearMonth.resolve(), yearMonth.instantiate(Util.classes(Integer.TYPE, Integer.TYPE), Util.objects(2009, 6)), yearMonth.instantiate(Util.classes(Integer.TYPE, Integer.TYPE), Util.objects(2014, 7)));
        ConditionalInstantiator monthDay = new ConditionalInstantiator("org.joda.time.MonthDay");
        this.addValues(monthDay.resolve(), monthDay.instantiate(Util.classes(Integer.TYPE, Integer.TYPE), Util.objects(6, 1)), monthDay.instantiate(Util.classes(Integer.TYPE, Integer.TYPE), Util.objects(6, 26)));
    }

    private <T> void addValues(Class<T> type, Object red, Object black) {
        this.prefabValues.addFactory(type, red, black);
    }

    private <T> void addFactory(Class<T> type, PrefabValueFactory<T> factory) {
        this.prefabValues.addFactory(type, factory);
    }

    private void addJavaFxCollection(String name, Class<?> copyFrom, String factoryMethod) {
        String className = JAVAFX_COLLECTIONS_PACKAGE + name;
        this.addFactory(Util.classForName(className), new ReflectiveCollectionCopyFactory(className, copyFrom, "javafx.collections.FXCollections", factoryMethod));
    }

    private void addJavaFxProperty(String declaredType, String actualType, Class<?> propertyType) {
        this.addFactory(Util.classForName(JAVAFX_PROPERTY_PACKAGE + declaredType), new ReflectiveJavaFxPropertyFactory(JAVAFX_PROPERTY_PACKAGE + actualType, propertyType));
    }

    private <T> void addNewGuavaCollection(String declaredType, String actualType) {
        Class<?> type = Util.classForName(GUAVA_PACKAGE + declaredType);
        ReflectiveCollectionFactory factory = ReflectiveCollectionFactory.callFactoryMethod(GUAVA_PACKAGE + actualType, "create");
        this.addFactory(type, factory);
    }

    private <T, U> void addNewGuavaCollection(String declaredType, String actualType, Class<U> parameterType, U parameterValue) {
        Class<?> type = Util.classForName(GUAVA_PACKAGE + declaredType);
        ReflectiveCollectionFactory factory = ReflectiveCollectionFactory.callFactoryMethodWithParameter(GUAVA_PACKAGE + actualType, "create", parameterType, parameterValue);
        this.addFactory(type, factory);
    }

    private <T> void addNewGuavaMap(String declaredType, String actualType) {
        Class<?> type = Util.classForName(GUAVA_PACKAGE + declaredType);
        ReflectiveMapFactory factory = ReflectiveMapFactory.callFactoryMethod(GUAVA_PACKAGE + actualType, "create");
        this.addFactory(type, factory);
    }

    private <T> void addNewGuavaMap(String declaredType, String actualType, Comparator<Object> comparator) {
        Class<?> type = Util.classForName(GUAVA_PACKAGE + declaredType);
        ReflectiveMapFactory factory = ReflectiveMapFactory.callFactoryMethodWithComparator(GUAVA_PACKAGE + actualType, "create", comparator);
        this.addFactory(type, factory);
    }

    private <T> void addNewGuavaTable(String declaredType, String actualType, Comparator<Object> comparator) {
        Class<?> type = Util.classForName(GUAVA_PACKAGE + declaredType);
        ReflectiveGuavaTableFactory factory = ReflectiveGuavaTableFactory.callFactoryMethodWithComparator(GUAVA_PACKAGE + actualType, "create", comparator);
        this.addFactory(type, factory);
    }

    private <T> void addNewGuavaTable(String declaredType, String actualType) {
        Class<?> type = Util.classForName(GUAVA_PACKAGE + declaredType);
        ReflectiveGuavaTableFactory factory = ReflectiveGuavaTableFactory.callFactoryMethod(GUAVA_PACKAGE + actualType, "create");
        this.addFactory(type, factory);
    }

    private void addCopiedGuavaCollection(String name, Class<?> copyFrom) {
        this.addCopiedGuavaCollection(name, copyFrom, "copyOf");
    }

    private void addCopiedGuavaCollection(String name, Class<?> copyFrom, String copyMethodName) {
        this.addCopiedGuavaCollection(name, copyFrom, copyFrom, copyMethodName);
    }

    private void addCopiedGuavaCollection(String name, Class<?> declaredCopyFrom, Class<?> actualCopyFrom, String copyMethodName) {
        this.addCopiedGuavaCollection(name, name, declaredCopyFrom, actualCopyFrom, copyMethodName);
    }

    private void addCopiedGuavaCollection(String declaredName, String actualName, Class<?> declaredCopyFrom, Class<?> actualCopyFrom, String copyMethodName) {
        String className = GUAVA_PACKAGE + actualName;
        this.addFactory(Util.classForName(GUAVA_PACKAGE + declaredName), new ReflectiveCollectionCopyFactory(className, declaredCopyFrom, actualCopyFrom, className, copyMethodName));
    }

    private static enum Dummy {
        RED,
        BLACK;

    }
}

