/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.commons.testing;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.Callable;

public final class EqualsTestUtil {
    public static <T> void assertEqualsImplementedCorrectly(Callable<T> objectBuilder) {
        EqualsTestUtil.assertEqualsImplementedCorrectly(objectBuilder, objectBuilder);
    }

    public static <T> void assertEqualsImplementedCorrectly(Callable<T> objectBuilder1, Callable<T> objectBuilder2) {
        try {
            T o1 = objectBuilder1.call();
            T o2 = objectBuilder2.call();
            EqualsTestUtil.assertEqualsImplementedCorrectly(o1, o2);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    @SuppressFBWarnings
    public static void assertEqualsImplementedCorrectly(Object o1, Object o2) {
        if (!o1.equals(o2)) {
            throw new AssertionError((Object)("Expected " + o1 + " ==  " + o2));
        }
        if (!o2.equals(o1)) {
            throw new AssertionError((Object)("Expected " + o2 + " ==  " + o1));
        }
        if (!o1.equals(o1)) {
            throw new AssertionError((Object)("Expected " + o1 + " ==  " + o1));
        }
        if (!o2.equals(o2)) {
            throw new AssertionError((Object)("Expected " + o2 + " ==  " + o2));
        }
        if (o1.equals(new EqualsTestUtil())) {
            throw new AssertionError((Object)("Type of " + o1 + " does not match expected class"));
        }
        if (o2.equals(new EqualsTestUtil())) {
            throw new AssertionError((Object)("Type of " + o2 + " does not match expected class"));
        }
        if (o1.equals(null)) {
            throw new AssertionError((Object)("Did not expect " + o1 + " == null"));
        }
        if (o2.equals(null)) {
            throw new AssertionError((Object)("Did not expect " + o2 + " == null"));
        }
        if (o1.hashCode() != o2.hashCode()) {
            throw new AssertionError((Object)String.format("Expected hash code of %s (%d) == %s (%d)", o1, o1.hashCode(), o2, o2.hashCode()));
        }
    }

    public static <T> void assertEqualsImplementedCorrectly(T o) {
        EqualsTestUtil.assertEqualsImplementedCorrectly(o, o);
    }

    private EqualsTestUtil() {
    }
}

