/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.commons.testing;

import java.io.IOException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import net.trajano.commons.testing.internal.NullHostnameVerifier;
import net.trajano.commons.testing.internal.NullX509TrustManager;

public final class DisableSslCertificateCheckUtil {
    private static boolean disabled;
    private static final Logger LOG;
    public static final HostnameVerifier NULL_HOSTNAME_VERIFIER;
    public static final X509TrustManager NULL_TRUST_MANAGER;
    private static HostnameVerifier originalHostnameVerifier;
    private static SSLSocketFactory originalSslSocketFactory;

    public static SSLContext buildUnsecureSslContext() throws GeneralSecurityException {
        SSLContext context = SSLContext.getInstance("TLSv1");
        TrustManager[] trustManagerArray = new TrustManager[]{NULL_TRUST_MANAGER};
        context.init(null, trustManagerArray, null);
        return context;
    }

    public static void disableChecks() throws GeneralSecurityException {
        if (disabled) {
            return;
        }
        try {
            new URL("https", "0", "/").getContent();
        }
        catch (IOException e) {
            LOG.log(Level.FINEST, "DisableSSLCertificateCheckUtil.disableCertificateCheck", e);
        }
        originalSslSocketFactory = HttpsURLConnection.getDefaultSSLSocketFactory();
        originalHostnameVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
        SSLContext context = DisableSslCertificateCheckUtil.buildUnsecureSslContext();
        HttpsURLConnection.setDefaultSSLSocketFactory(context.getSocketFactory());
        HttpsURLConnection.setDefaultHostnameVerifier(NULL_HOSTNAME_VERIFIER);
        disabled = true;
    }

    public static void reenableChecks() {
        if (!disabled) {
            return;
        }
        HttpsURLConnection.setDefaultSSLSocketFactory(originalSslSocketFactory);
        HttpsURLConnection.setDefaultHostnameVerifier(originalHostnameVerifier);
        disabled = false;
    }

    private DisableSslCertificateCheckUtil() {
    }

    static {
        LOG = Logger.getLogger(DisableSslCertificateCheckUtil.class.getName(), "META-INF.Messages");
        NULL_HOSTNAME_VERIFIER = new NullHostnameVerifier();
        NULL_TRUST_MANAGER = new NullX509TrustManager();
    }
}

