/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.commons.testing;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public final class UtilityClassTestUtil {
    private static final ResourceBundle R = ResourceBundle.getBundle("META-INF.Messages");

    private static void assertUtilityClassClassWellDefined(Class<?> clazz) {
        if (!Modifier.isFinal(clazz.getModifiers())) {
            throw new AssertionError((Object)MessageFormat.format(R.getString("UtilityClassTestUtil.notFinal"), clazz));
        }
        if (clazz.getDeclaredConstructors().length != 1) {
            throw new AssertionError((Object)MessageFormat.format(R.getString("UtilityClassTestUtil.notOneConstructor"), clazz));
        }
    }

    private static void assertUtilityClassConstructorWellDefined(Constructor<?> constructor) throws ReflectiveOperationException {
        if (constructor.isAccessible() || !Modifier.isPrivate(constructor.getModifiers())) {
            throw new AssertionError((Object)MessageFormat.format(R.getString("UtilityClassTestUtil.constructorNotPrivate"), constructor));
        }
        constructor.setAccessible(true);
        constructor.newInstance(new Object[0]);
        constructor.setAccessible(false);
    }

    private static void assertUtilityClassMethodsWellDefined(Class<?> clazz) {
        for (Method method : clazz.getMethods()) {
            if (!Modifier.isStatic(method.getModifiers()) && method.getDeclaringClass().equals(clazz)) {
                throw new AssertionError((Object)MessageFormat.format(R.getString("UtilityClassTestUtil.methodNotStatic"), method));
            }
        }
    }

    public static void assertUtilityClassWellDefined(Class<?> clazz) throws ReflectiveOperationException {
        UtilityClassTestUtil.assertUtilityClassClassWellDefined(clazz);
        Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
        UtilityClassTestUtil.assertUtilityClassConstructorWellDefined(constructor);
        UtilityClassTestUtil.assertUtilityClassMethodsWellDefined(clazz);
    }

    private UtilityClassTestUtil() {
    }
}

