/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.commons.testing;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public final class ResourceUtil {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] getResourceAsBytes(Class<?> clazz, String name) {
        try (InputStream is = ResourceUtil.getResourceAsStream(clazz, name);){
            byte[] byArray = ResourceUtil.streamToBytes(is);
            return byArray;
        }
        catch (IOException e) {
            throw new AssertionError(e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] getResourceAsBytes(String name) {
        try (InputStream is = ResourceUtil.getResourceAsStream(name);){
            byte[] byArray = ResourceUtil.streamToBytes(is);
            return byArray;
        }
        catch (IOException e) {
            throw new AssertionError(e.getMessage(), e);
        }
    }

    public static InputStream getResourceAsStream(Class<?> clazz, String name) {
        InputStream is = clazz.getResourceAsStream(name);
        if (is == null) {
            throw new AssertionError((Object)String.format("Unable to locate resource %s in %s", name, clazz));
        }
        return is;
    }

    public static InputStream getResourceAsStream(String name) {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(name);
        if (is == null) {
            throw new AssertionError((Object)String.format("Unable to locate resource %s in context class loader", name));
        }
        return is;
    }

    public static String getResourceAsString(Class<?> clazz, String name) {
        try {
            return new String(ResourceUtil.getResourceAsBytes(clazz, name), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError(e.getMessage(), e);
        }
    }

    public static String getResourceAsString(String name) {
        try {
            return new String(ResourceUtil.getResourceAsBytes(name), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError(e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static File getResourceCopy(Class<?> clazz, String name) {
        try (InputStream is = ResourceUtil.getResourceAsStream(clazz, name);){
            File file = ResourceUtil.streamToTempFile(is);
            return file;
        }
        catch (IOException e) {
            throw new AssertionError(e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static File getResourceCopy(String name) {
        try (InputStream is = ResourceUtil.getResourceAsStream(name);){
            File file = ResourceUtil.streamToTempFile(is);
            return file;
        }
        catch (IOException e) {
            throw new AssertionError(e.getMessage(), e);
        }
    }

    public static byte[] streamToBytes(InputStream is) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int c = is.read();
            while (c != -1) {
                baos.write(c);
                c = is.read();
            }
            baos.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new AssertionError(e.getMessage(), e);
        }
    }

    public static File streamToTempFile(InputStream is) {
        try {
            File file = File.createTempFile("test", ".tmp");
            FileOutputStream os = new FileOutputStream(file);
            int c = is.read();
            while (c != -1) {
                os.write(c);
                c = is.read();
            }
            os.close();
            return file;
        }
        catch (IOException e) {
            throw new AssertionError(e.getMessage(), e);
        }
    }

    private ResourceUtil() {
    }
}

