/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.database;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.pmd.util.database.DBType;

public class DBURI {
    private static final String CLASS_NAME = DBURI.class.getCanonicalName();
    private static final Logger LOGGER = Logger.getLogger(CLASS_NAME);
    private URI uri;
    private DBType dbType;
    private String url;
    private String subprotocol;
    private String subnamePrefix;
    private Map<String, String> parameters;
    private List<String> schemasList;
    private List<String> sourceCodeTypesList;
    private List<String> sourceCodeNamesList;
    private List<String> languagesList;
    private String driverClass;
    private String characterSet;
    private String sourceCodeTypes;
    private String sourceCodeNames;
    private String languages;
    private int sourceCodeType;

    public DBURI(String string) throws URISyntaxException {
        this.uri = new URI(string);
        try {
            String[] splitURI = string.split("\\?");
            this.url = splitURI.length > 1 ? splitURI[0] : string;
            LOGGER.log(Level.FINE, "Extracted URL={0}", this.url);
            this.setFields();
            if (splitURI.length > 1) {
                String chimeraString = "http://local?" + string.substring(this.url.length() + 1);
                LOGGER.log(Level.FINEST, "chimeraString={0}", chimeraString);
                URI chimeraURI = new URI(chimeraString);
                DBURI.dump("chimeraURI", chimeraURI);
                this.parameters = this.getParameterMap(chimeraURI);
                LOGGER.log(Level.FINEST, "parameterMap=={0}", this.parameters);
                this.characterSet = this.parameters.get("characterset");
                this.sourceCodeTypes = this.parameters.get("sourcecodetypes");
                this.sourceCodeNames = this.parameters.get("sourcecodenames");
                this.languages = this.parameters.get("languages");
                if (null != this.sourceCodeNames) {
                    this.sourceCodeNamesList = Arrays.asList(this.sourceCodeNames.split(","));
                }
                if (null != this.languages) {
                    this.languagesList = Arrays.asList(this.languages.split(","));
                }
                if (null != this.parameters.get("schemas")) {
                    this.schemasList = Arrays.asList(this.parameters.get("schemas").split(","));
                }
                if (null != this.sourceCodeTypes) {
                    this.sourceCodeTypesList = Arrays.asList(this.sourceCodeTypes.split(","));
                }
            }
        }
        catch (URISyntaxException ex) {
            URISyntaxException uriException = new URISyntaxException(string, "Problem generating DBURI.");
            uriException.initCause(ex);
            throw uriException;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public DBURI(String scheme, String userInfo, String host, int port, String path, String query, String fragment) throws URISyntaxException {
        this.uri = new URI(scheme, userInfo, host, port, path, query, fragment);
    }

    private Map<String, String> getParameterMap(URI dburi) throws UnsupportedEncodingException {
        HashMap<String, String> map = new HashMap<String, String>();
        String query = dburi.getRawQuery();
        LOGGER.log(Level.FINEST, "dburi,getQuery()={0}", query);
        if (null != query && !query.equals("")) {
            String[] params;
            for (String param : params = query.split("&")) {
                String[] splits = param.split("=");
                String name = splits[0];
                String value = null;
                if (splits.length > 1) {
                    value = splits[1];
                }
                map.put(name, null == value ? value : URLDecoder.decode(value, "UTF-8"));
            }
        }
        return map;
    }

    static void dump(String description, URI dburi) {
        String dumpString = String.format("dump (%s)\n: isOpaque=%s, isAbsolute=%s Scheme=%s,\n SchemeSpecificPart=%s,\n Host=%s,\n Port=%s,\n Path=%s,\n Fragment=%s,\n Query=%s\n", description, dburi.isOpaque(), dburi.isAbsolute(), dburi.getScheme(), dburi.getSchemeSpecificPart(), dburi.getHost(), dburi.getPort(), dburi.getPath(), dburi.getFragment(), dburi.getQuery());
        LOGGER.fine(dumpString);
        String query = dburi.getQuery();
        if (null != query && !query.equals("")) {
            String[] params = query.split("&");
            HashMap<String, String> map = new HashMap<String, String>();
            for (String param : params) {
                String[] splits = param.split("=");
                String name = splits[0];
                String value = null;
                if (splits.length > 1) {
                    value = splits[1];
                }
                map.put(name, value);
                LOGGER.fine(String.format("name=%s,value=%s\n", name, value));
            }
        }
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public DBType getDbType() {
        return this.dbType;
    }

    public void setDbType(DBType dbType) {
        this.dbType = dbType;
    }

    public List<String> getSchemasList() {
        return this.schemasList;
    }

    public void setSchemasList(List<String> schemasList) {
        this.schemasList = schemasList;
    }

    public List<String> getSourceCodeTypesList() {
        return this.sourceCodeTypesList;
    }

    public void setSourceCodeTypesList(List<String> sourceCodeTypesList) {
        this.sourceCodeTypesList = sourceCodeTypesList;
    }

    public List<String> getSourceCodeNamesList() {
        return this.sourceCodeNamesList;
    }

    public void setSourceCodeNamesList(List<String> sourceCodeNamesList) {
        this.sourceCodeNamesList = sourceCodeNamesList;
    }

    public List<String> getLanguagesList() {
        return this.languagesList;
    }

    public void setLanguagesList(List<String> languagesList) {
        this.languagesList = languagesList;
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public void setDriverClass(String driverClass) {
        this.driverClass = driverClass;
    }

    public String getCharacterSet() {
        return this.characterSet;
    }

    public void setCharacterSet(String characterSet) {
        this.characterSet = characterSet;
    }

    public int getSourceCodeType() {
        return this.sourceCodeType;
    }

    public void setSourceCodeType(int sourceCodeType) {
        this.sourceCodeType = sourceCodeType;
    }

    public String getSubprotocol() {
        return this.subprotocol;
    }

    public void setSubprotocol(String subprotocol) {
        this.subprotocol = subprotocol;
    }

    public String getSubnamePrefix() {
        return this.subnamePrefix;
    }

    public void setSubnamePrefix(String subnamePrefix) {
        this.subnamePrefix = subnamePrefix;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String jdbcURL) {
        this.url = jdbcURL;
    }

    private void setFields() throws URISyntaxException, IOException {
        if (this.url.startsWith("jdbc:")) {
            String[] uriParts;
            URI jdbcURI = new URI(this.getURL().substring(5));
            LOGGER.log(Level.FINE, "setFields - substr(jdbcURL,5):{0}", this.getURL().substring(5));
            DBURI.dump("substr(jdbcURL,5)", jdbcURI);
            for (String part : uriParts = this.url.split(":")) {
                LOGGER.log(Level.FINEST, "JDBCpart={0}", part);
            }
            if (3 == uriParts.length) {
                this.subprotocol = uriParts[1];
            } else if (4 <= uriParts.length) {
                this.subprotocol = uriParts[1];
                this.subnamePrefix = uriParts[2];
            } else {
                throw new URISyntaxException(this.getURL(), "Could not understand JDBC URL", 1);
            }
            LOGGER.log(Level.FINE, "subprotocol={0}'' subnamePrefix={1}", new Object[]{this.subprotocol, this.subnamePrefix});
            this.dbType = new DBType(this.subprotocol, this.subnamePrefix);
            LOGGER.log(Level.FINER, "DBType properties found at {0} with {1} properties.", new Object[]{this.dbType.getPropertiesSource(), this.dbType.getProperties().size()});
            LOGGER.log(Level.FINEST, "DBType properties are:- {0}", this.dbType.getProperties());
            if (null != this.dbType.getDriverClass()) {
                this.driverClass = this.dbType.getDriverClass();
            }
            if (null != this.dbType.getCharacterSet()) {
                this.characterSet = this.dbType.getCharacterSet();
            }
            if (null != this.dbType.getLanguages()) {
                this.languages = this.dbType.getLanguages();
            }
            if (null != this.dbType.getSourceCodeTypes()) {
                this.sourceCodeTypes = this.dbType.getSourceCodeTypes();
            }
            LOGGER.finer("DBType other properties follow  ...");
            if (null != this.dbType.getProperties().getProperty("schemas")) {
                this.schemasList = Arrays.asList(this.dbType.getProperties().getProperty("schemas").split(","));
            }
            this.sourceCodeNames = this.dbType.getProperties().getProperty("sourcecodenames");
            String returnType = this.dbType.getProperties().getProperty("returnType");
            if (null != returnType) {
                this.sourceCodeType = Integer.parseInt(returnType);
            }
            LOGGER.finer("DBType populating lists ");
            if (null != this.sourceCodeNames) {
                this.sourceCodeNamesList = Arrays.asList(this.sourceCodeNames.split(","));
            }
            if (null != this.languages) {
                this.languagesList = Arrays.asList(this.languages.split(","));
            }
            if (null != this.sourceCodeTypes) {
                this.sourceCodeTypesList = Arrays.asList(this.sourceCodeTypes.split(","));
            }
            LOGGER.finer("DBType lists generated");
        }
    }

    public String toString() {
        return this.uri.toASCIIString();
    }
}

