/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule.properties;

import java.util.Map;
import net.sourceforge.pmd.PropertyDescriptorFactory;
import net.sourceforge.pmd.lang.rule.properties.AbstractNumericProperty;
import net.sourceforge.pmd.lang.rule.properties.factories.BasicPropertyDescriptorFactory;

public class FloatProperty
extends AbstractNumericProperty<Float> {
    public static final PropertyDescriptorFactory FACTORY = new BasicPropertyDescriptorFactory<FloatProperty>(Float.TYPE, NUMBER_FIELD_TYPES_BY_KEY){

        public FloatProperty createWith(Map<String, String> valuesById) {
            String[] minMax = 1.minMaxFrom(valuesById);
            return new FloatProperty(this.nameIn(valuesById), this.descriptionIn(valuesById), Float.valueOf(minMax[0]), Float.valueOf(minMax[1]), Float.valueOf(this.numericDefaultValueIn(valuesById)), 0.0f);
        }
    };

    public FloatProperty(String theName, String theDescription, Float min, Float max, Float theDefault, float theUIOrder) {
        super(theName, theDescription, Float.valueOf(min.floatValue()), Float.valueOf(max.floatValue()), Float.valueOf(theDefault.floatValue()), theUIOrder);
    }

    public FloatProperty(String theName, String theDescription, String minStr, String maxStr, String defaultStr, float theUIOrder) {
        this(theName, theDescription, FloatProperty.floatFrom(minStr), FloatProperty.floatFrom(maxStr), FloatProperty.floatFrom(defaultStr), theUIOrder);
    }

    public static Float floatFrom(String numberString) {
        return Float.valueOf(numberString);
    }

    @Override
    public Class<Float> type() {
        return Float.class;
    }

    @Override
    protected Object createFrom(String value) {
        return FloatProperty.floatFrom(value);
    }
}

